/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.world.data.PlayerCompanionData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class UpdateCompanionDataMessage {
    private final Map<UUID, PlayerCompanionData.CompanionData> companionData;

    public UpdateCompanionDataMessage(Map<UUID, PlayerCompanionData.CompanionData> companionData) {
        this.companionData = companionData;
    }

    public static void encode(UpdateCompanionDataMessage message, FriendlyByteBuf buffer) {
        buffer.m_130130_(message.companionData.size());
        message.companionData.forEach((uuid, data) -> {
            buffer.m_130077_(uuid);
            buffer.m_130079_(data.save());
        });
    }

    public static UpdateCompanionDataMessage decode(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        HashMap<UUID, PlayerCompanionData.CompanionData> data = new HashMap<UUID, PlayerCompanionData.CompanionData>();
        for (int i = 0; i < size; ++i) {
            UUID uuid = buffer.m_130259_();
            PlayerCompanionData.CompanionData companionData = new PlayerCompanionData.CompanionData(uuid);
            companionData.load(buffer.m_130260_());
            data.put(uuid, companionData);
        }
        return new UpdateCompanionDataMessage(data);
    }

    public static void handle(UpdateCompanionDataMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> PlayerCompanionData.CLIENT.putAll(message.companionData));
        context.setPacketHandled(true);
    }
}

