/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.world.data.GodAltarData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class UpdateGodAltarDataMessage {
    private final List<GodAltarData.Entry> entries;

    public UpdateGodAltarDataMessage(List<GodAltarData.Entry> entries) {
        this.entries = entries;
    }

    public static void encode(UpdateGodAltarDataMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entries.size());
        message.entries.forEach(entry -> entry.writeNbt().ifPresent(arg_0 -> ((FriendlyByteBuf)buffer).m_130079_(arg_0)));
    }

    public static UpdateGodAltarDataMessage decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList<GodAltarData.Entry> entries = new ArrayList<GodAltarData.Entry>();
        for (int i = 0; i < size; ++i) {
            GodAltarData.Entry entry = new GodAltarData.Entry();
            entry.readNbt(buffer.m_130260_());
            entries.add(entry);
        }
        return new UpdateGodAltarDataMessage(entries);
    }

    public static void handle(UpdateGodAltarDataMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            GodAltarData.CLIENT = message.entries;
        });
        context.setPacketHandled(true);
    }
}

