/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.world.data.ParadoxCrystalData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class UpdateParadoxDataMessage {
    private final Map<UUID, ParadoxCrystalData.Entry> changed;

    public UpdateParadoxDataMessage(Map<UUID, ParadoxCrystalData.Entry> changed) {
        this.changed = changed;
    }

    public static void encode(UpdateParadoxDataMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.changed.size());
        message.changed.forEach((uuid, entry) -> {
            buffer.m_130077_(uuid);
            buffer.m_130079_(entry.writeNbt().orElse(new CompoundTag()));
        });
    }

    public static UpdateParadoxDataMessage decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<UUID, ParadoxCrystalData.Entry> changed = new HashMap<UUID, ParadoxCrystalData.Entry>();
        for (int i = 0; i < size; ++i) {
            UUID uuid = buffer.m_130259_();
            CompoundTag tag = buffer.m_130260_();
            ParadoxCrystalData.Entry entry = new ParadoxCrystalData.Entry();
            entry.readNbt(tag);
            changed.put(uuid, entry);
        }
        return new UpdateParadoxDataMessage(changed);
    }

    public static void handle(UpdateParadoxDataMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ParadoxCrystalData.CLIENT.putAll(message.changed));
        context.setPacketHandled(true);
    }
}

