/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.world.data.PersonalVaultData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class UpdatePersonalVaultDataMessage {
    private final Map<UUID, PersonalVaultData.Entry> entries;

    public UpdatePersonalVaultDataMessage(Map<UUID, PersonalVaultData.Entry> entries) {
        this.entries = entries;
    }

    public static void encode(UpdatePersonalVaultDataMessage msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.entries.size());
        msg.entries.forEach((id, entry) -> {
            buf.m_130077_(id);
            CompoundTag tag = entry.writeNbt().orElse(new CompoundTag());
            buf.m_130079_(tag);
        });
    }

    public static UpdatePersonalVaultDataMessage decode(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        HashMap<UUID, PersonalVaultData.Entry> map = new HashMap<UUID, PersonalVaultData.Entry>();
        for (int i = 0; i < size; ++i) {
            UUID id = buf.m_130259_();
            CompoundTag tag = buf.m_130260_();
            PersonalVaultData.Entry entry = new PersonalVaultData.Entry();
            entry.readNbt(tag);
            map.put(id, entry);
        }
        return new UpdatePersonalVaultDataMessage(map);
    }

    public static void handle(UpdatePersonalVaultDataMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> UpdatePersonalVaultDataMessage.apply(msg));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void apply(UpdatePersonalVaultDataMessage msg) {
        PersonalVaultData.CLIENT.putAll(msg.entries);
    }
}

