/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.world.data.PlayerTitlesData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class UpdateTitlesDataMessage {
    private final Map<UUID, PlayerTitlesData.Entry> changed;

    public UpdateTitlesDataMessage(Map<UUID, PlayerTitlesData.Entry> changed) {
        this.changed = changed;
    }

    public static void encode(UpdateTitlesDataMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.changed.size());
        message.changed.forEach((uuid, entry) -> {
            buffer.m_130077_(uuid);
            buffer.m_130079_(entry.writeNbt().orElse(new CompoundTag()));
        });
    }

    public static UpdateTitlesDataMessage decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<UUID, PlayerTitlesData.Entry> changed = new HashMap<UUID, PlayerTitlesData.Entry>();
        for (int i = 0; i < size; ++i) {
            UUID uuid = buffer.m_130259_();
            CompoundTag tag = buffer.m_130260_();
            PlayerTitlesData.Entry entry = new PlayerTitlesData.Entry();
            entry.readNbt(tag);
            changed.put(uuid, entry);
        }
        return new UpdateTitlesDataMessage(changed);
    }

    public static void handle(UpdateTitlesDataMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> PlayerTitlesData.CLIENT.putAll(message.changed));
        context.setPacketHandled(true);
    }
}

