/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.world.storage.WorldZone;
import iskallia.vault.core.world.storage.WorldZones;
import iskallia.vault.world.data.WorldZonesData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class UpdateWorldZonesDataMessage {
    private final boolean reset;
    private final Collection<ResourceKey<Level>> addedDimensions;
    private final Collection<ResourceKey<Level>> removedDimensions;
    private final Map<ResourceKey<Level>, Map<Integer, WorldZone>> addedZones;
    private final Map<ResourceKey<Level>, Collection<Integer>> removedZones;

    private UpdateWorldZonesDataMessage() {
        this.reset = false;
        this.addedDimensions = new ArrayList<ResourceKey<Level>>();
        this.removedDimensions = new ArrayList<ResourceKey<Level>>();
        this.addedZones = new HashMap<ResourceKey<Level>, Map<Integer, WorldZone>>();
        this.removedZones = new HashMap<ResourceKey<Level>, Collection<Integer>>();
    }

    private UpdateWorldZonesDataMessage(boolean reset, Collection<ResourceKey<Level>> addedDimensions, Collection<ResourceKey<Level>> removedDimensions, Map<ResourceKey<Level>, Map<Integer, WorldZone>> addedZones, Map<ResourceKey<Level>, Collection<Integer>> removedZones) {
        this.reset = reset;
        this.addedDimensions = addedDimensions;
        this.removedDimensions = removedDimensions;
        this.addedZones = addedZones;
        this.removedZones = removedZones;
    }

    public static UpdateWorldZonesDataMessage full(WorldZonesData data) {
        HashMap<ResourceKey<Level>, Map<Integer, WorldZone>> added = new HashMap<ResourceKey<Level>, Map<Integer, WorldZone>>();
        data.getZones().forEach((dimension, zones) -> {
            Map map = added.computeIfAbsent((ResourceKey<Level>)dimension, key -> new HashMap());
            map.putAll(zones.getAll());
        });
        return new UpdateWorldZonesDataMessage(true, data.getZones().keySet(), new ArrayList<ResourceKey<Level>>(), added, new HashMap<ResourceKey<Level>, Collection<Integer>>());
    }

    public static UpdateWorldZonesDataMessage diff(WorldZonesData data) {
        HashMap<ResourceKey<Level>, Map<Integer, WorldZone>> added = new HashMap<ResourceKey<Level>, Map<Integer, WorldZone>>();
        HashMap<ResourceKey<Level>, Collection<Integer>> removed = new HashMap<ResourceKey<Level>, Collection<Integer>>();
        data.getZones().forEach((dimension, zones) -> {
            if (zones.getAddedZones().isEmpty() && zones.getRemovedZones().isEmpty()) {
                return;
            }
            Map addedMap = added.computeIfAbsent((ResourceKey<Level>)dimension, key -> new HashMap());
            Collection removedMap = removed.computeIfAbsent((ResourceKey<Level>)dimension, key -> new ArrayList());
            zones.getAddedZones().forEach(index -> zones.get(index).ifPresent(zone -> addedMap.put(index, zone)));
            removedMap.addAll(zones.getRemovedZones());
        });
        return new UpdateWorldZonesDataMessage(data.isCleared(), data.getAddedDimensions(), data.getRemovedDimensions(), added, removed);
    }

    public boolean isEmpty() {
        return !this.reset && this.addedDimensions.isEmpty() && this.removedDimensions.isEmpty() && this.addedZones.isEmpty() && this.removedZones.isEmpty();
    }

    public static void encode(UpdateWorldZonesDataMessage message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.reset);
        buffer.m_178352_(message.addedDimensions, (buf, dimension) -> Adapters.DIMENSION.writeBytes((ResourceKey<Level>)dimension, (ByteBuf)buffer));
        buffer.m_178352_(message.removedDimensions, (buf, dimension) -> Adapters.DIMENSION.writeBytes((ResourceKey<Level>)dimension, (ByteBuf)buffer));
        buffer.m_178355_(message.addedZones, (buf, dimension) -> Adapters.DIMENSION.writeBytes((ResourceKey<Level>)dimension, (ByteBuf)buffer), (buf, zones) -> buffer.m_178355_(zones, FriendlyByteBuf::m_130130_, (buf2, zone) -> {
            CompoundTag nbt = Adapters.WORLD_ZONE.writeNbt((WorldZone)zone).orElseThrow();
            buf2.m_130079_(nbt);
        }));
        buffer.m_178355_(message.removedZones, (buf, dimension) -> Adapters.DIMENSION.writeBytes((ResourceKey<Level>)dimension, (ByteBuf)buffer), (buf, zones) -> buffer.m_178352_(zones, FriendlyByteBuf::m_130130_));
    }

    public static UpdateWorldZonesDataMessage decode(FriendlyByteBuf buffer) {
        boolean reset = buffer.readBoolean();
        List addedDimensions = (List)buffer.m_178371_(ArrayList::new, buf -> Adapters.DIMENSION.readBytes((ByteBuf)buffer).orElseThrow());
        List removedDimensions = (List)buffer.m_178371_(ArrayList::new, buf -> Adapters.DIMENSION.readBytes((ByteBuf)buffer).orElseThrow());
        Map addedZones = buffer.m_178374_(HashMap::new, buf -> Adapters.DIMENSION.readBytes((ByteBuf)buffer).orElseThrow(), buf -> buffer.m_178374_(HashMap::new, FriendlyByteBuf::m_130242_, buf2 -> {
            CompoundTag nbt = buf2.m_130260_();
            return Adapters.WORLD_ZONE.readNbt(nbt).orElseThrow();
        }));
        Map removedZones = buffer.m_178374_(HashMap::new, buf -> Adapters.DIMENSION.readBytes((ByteBuf)buffer).orElseThrow(), buf -> buf.m_178366_(FriendlyByteBuf::m_130242_));
        return new UpdateWorldZonesDataMessage(reset, addedDimensions, removedDimensions, addedZones, removedZones);
    }

    public static void handle(UpdateWorldZonesDataMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (message.reset) {
                WorldZonesData.CLIENT.clear();
            }
            message.removedDimensions.forEach(dimension -> WorldZonesData.CLIENT.getZones().remove(dimension));
            message.addedDimensions.forEach(dimension -> WorldZonesData.CLIENT.getZones().put((ResourceKey<Level>)dimension, new WorldZones()));
            message.removedZones.forEach((dimension, indices) -> {
                WorldZones zones = WorldZonesData.CLIENT.getZones().get(dimension);
                if (zones == null) {
                    return;
                }
                indices.forEach(zones::remove);
            });
            message.addedZones.forEach((dimension, added) -> {
                WorldZones zones = WorldZonesData.CLIENT.getZones().computeIfAbsent((ResourceKey<Level>)dimension, key -> new WorldZones());
                added.forEach(zones::add);
            });
            WorldZonesData.CLIENT.refreshDiff();
        });
        context.setPacketHandled(true);
    }
}

