/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import io.netty.buffer.ByteBuf;
import iskallia.vault.block.entity.VaultEnchanterTileEntity;
import iskallia.vault.container.VaultEnchanterContainer;
import iskallia.vault.util.EnchantmentEntry;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class VaultEnchanterEnchantMessage {
    private final BlockPos pos;
    private final EnchantmentEntry entry;

    public VaultEnchanterEnchantMessage(BlockPos pos, EnchantmentEntry entry) {
        this.pos = pos;
        this.entry = entry;
    }

    public static void encode(VaultEnchanterEnchantMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        message.entry.writeBytes((ByteBuf)buffer);
    }

    public static VaultEnchanterEnchantMessage decode(FriendlyByteBuf buffer) {
        return new VaultEnchanterEnchantMessage(buffer.m_130135_(), new EnchantmentEntry((ByteBuf)buffer));
    }

    public static void handle(VaultEnchanterEnchantMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            BlockPos pos = message.pos;
            BlockEntity tile = player.m_183503_().m_7702_(pos);
            AbstractContainerMenu patt1702$temp = player.f_36096_;
            if (!(patt1702$temp instanceof VaultEnchanterContainer)) {
                return;
            }
            VaultEnchanterContainer container = (VaultEnchanterContainer)patt1702$temp;
            if (!(tile instanceof VaultEnchanterTileEntity)) {
                return;
            }
            VaultEnchanterTileEntity enchanterTile = (VaultEnchanterTileEntity)tile;
            ItemStack input = enchanterTile.getInventory().m_8020_(0);
            if (input.m_41619_() || !message.entry.isValid()) {
                return;
            }
            if (message.entry.getCost().tryConsume(player)) {
                message.entry.apply(input);
                container.m_38946_();
                player.m_183503_().m_5594_(null, pos, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, player.m_183503_().f_46441_.nextFloat() * 0.1f + 0.9f);
            }
        });
        context.setPacketHandled(true);
    }
}

