/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.block.entity.VaultEnhancementAltarTileEntity;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.enhancement.EnhancementData;
import iskallia.vault.core.vault.enhancement.EnhancementTask;
import iskallia.vault.gear.GearRollHelper;
import iskallia.vault.gear.VaultGearModifierHelper;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.world.data.ServerVaults;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class VaultEnhancementRequestMessage {
    private final BlockPos altarPos;

    public VaultEnhancementRequestMessage(BlockPos altarPos) {
        this.altarPos = altarPos;
    }

    public static void encode(VaultEnhancementRequestMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.altarPos);
    }

    public static VaultEnhancementRequestMessage decode(FriendlyByteBuf buffer) {
        return new VaultEnhancementRequestMessage(buffer.m_130135_());
    }

    public static void handle(VaultEnhancementRequestMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            EnhancementTask<?> task;
            ServerPlayer player = context.getSender();
            BlockPos pos = message.altarPos;
            BlockEntity tile = player.m_183503_().m_7702_(pos);
            if (!(tile instanceof VaultEnhancementAltarTileEntity)) {
                return;
            }
            VaultEnhancementAltarTileEntity altarTile = (VaultEnhancementAltarTileEntity)tile;
            if (!altarTile.canBeUsed((Player)player)) {
                return;
            }
            ItemStack gearItem = altarTile.getInventory().m_8020_(0);
            if (!AttributeGearData.hasData(gearItem) || !((AttributeGearData)AttributeGearData.read(gearItem)).isModifiable()) {
                return;
            }
            Vault vault = ServerVaults.get((Level)player.m_183503_()).orElse(null);
            if (!(vault == null || (task = EnhancementData.getForAltar(altarTile.getUUID()).get(player.m_142081_())) != null && task.isFinished())) {
                return;
            }
            if (VaultGearModifierHelper.createOrReplaceAbilityEnhancementModifier(gearItem, GearRollHelper.rand)) {
                altarTile.setUsedByPlayer((Player)player);
                player.m_183503_().m_5594_(null, pos, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, player.m_21187_().nextFloat() * 0.1f + 0.9f);
            }
        });
        context.setPacketHandled(true);
    }
}

