/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.block.entity.base.ForgeRecipeTileEntity;
import iskallia.vault.config.recipe.ForgeRecipeType;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.container.spi.ForgeRecipeContainer;
import iskallia.vault.event.event.ForgeGearEvent;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ForgeParticleMessage;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.util.SidedHelper;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class VaultForgeRequestCraftMessage {
    private final ResourceLocation recipe;
    private final int level;
    private final boolean shift;

    public VaultForgeRequestCraftMessage(ResourceLocation recipe, int level, boolean shift) {
        this.recipe = recipe;
        this.level = level;
        this.shift = shift;
    }

    public static void encode(VaultForgeRequestCraftMessage message, FriendlyByteBuf buffer) {
        buffer.m_130085_(message.recipe);
        buffer.writeInt(message.level);
        buffer.writeBoolean(message.shift);
    }

    public static VaultForgeRequestCraftMessage decode(FriendlyByteBuf buffer) {
        return new VaultForgeRequestCraftMessage(buffer.m_130281_(), buffer.readInt(), buffer.readBoolean());
    }

    public static void handle(VaultForgeRequestCraftMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            AbstractContainerMenu patt2264$temp;
            ServerPlayer requester = context.getSender();
            if (requester == null || !((patt2264$temp = requester.f_36096_) instanceof ForgeRecipeContainer)) {
                return;
            }
            ForgeRecipeContainer container = (ForgeRecipeContainer)patt2264$temp;
            if (!container.getResultSlot().m_7993_().m_41619_()) {
                return;
            }
            Object tile = container.getTile();
            if (tile == null) {
                return;
            }
            VaultForgeRecipe recipe = null;
            for (ForgeRecipeType type : ((ForgeRecipeTileEntity)tile).getSupportedRecipeTypes()) {
                VaultForgeRecipe found = type.getRecipe(message.recipe);
                if (found == null || !found.canCraft((Player)requester)) continue;
                recipe = found;
                break;
            }
            if (recipe == null) {
                return;
            }
            Inventory playerInventory = requester.m_150109_();
            OverSizedInventory tileInventory = ((ForgeRecipeTileEntity)tile).getInventory();
            ArrayList<OverSizedItemStack> consumed = new ArrayList<OverSizedItemStack>();
            if (InventoryUtil.consumeInputs(recipe.getInputs(), playerInventory, tileInventory, true) && InventoryUtil.consumeInputs(recipe.getInputs(), playerInventory, tileInventory, false, consumed)) {
                int level = Mth.m_14045_((int)message.level, (int)0, (int)Math.min(ModConfigs.LEVELS_META.getMaxLevel(), SidedHelper.getVaultLevel((Player)requester)));
                ItemStack output = recipe.createOutput(consumed, requester, level);
                if (message.shift) {
                    if (!requester.m_150109_().m_36054_(output)) {
                        container.getResultSlot().m_5852_(output);
                    }
                } else {
                    container.getResultSlot().m_5852_(output);
                }
                requester.f_19853_.m_46796_(1030, tile.m_58899_(), 0);
                container.m_38946_();
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ForgeParticleMessage(tile.m_58899_()));
                MinecraftForge.EVENT_BUS.post((Event)new ForgeGearEvent((Player)requester, recipe));
            }
        });
        context.setPacketHandled(true);
    }
}

