/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModGameRules;
import iskallia.vault.world.SpectatorMode;
import iskallia.vault.world.VaultCrystalMode;
import iskallia.vault.world.VaultCrystalRecipeScaling;
import iskallia.vault.world.VaultExperience;
import iskallia.vault.world.VaultLoot;
import iskallia.vault.world.VaultMode;
import iskallia.vault.world.VaultPartyExpSharing;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class VaultRulesUpdateMessage {
    private final boolean joinRequireParty;
    private final int vaultTimer;
    private final boolean allowWaypoints;
    private final String vaultMode;
    private final String vaultLoot;
    private final String vaultExperience;
    private final String vaultCrystalMode;
    private final boolean noResearchTeamPenalty;
    private final boolean allowMentorBrew;
    private final boolean allowKnowledgeBrew;
    private final boolean boostPenalty;
    private final int vaultLock;
    private final String vaultPartyExpSharing;
    private final String vaultCrystalRecipeScaling;
    private final String spectatorMode;
    private final boolean spectatorPartyOnly;
    private final boolean partyMapSharing;
    private final boolean locker;

    public VaultRulesUpdateMessage(boolean joinRequireParty, int vaultTimer, boolean allowWaypoints, String vaultMode, String vaultLoot, String vaultExperience, String vaultCrystalMode, boolean noResearchTeamPenalty, boolean allowMentorBrew, boolean allowKnowledgeBrew, boolean boostPenalty, int vaultLock, String vaultPartyExpSharing, String vaultCrystalRecipeScaling, String spectatorMode, boolean spectatorPartyOnly, boolean partyMapSharing, boolean locker) {
        this.joinRequireParty = joinRequireParty;
        this.vaultTimer = vaultTimer;
        this.allowWaypoints = allowWaypoints;
        this.vaultMode = vaultMode;
        this.vaultLoot = vaultLoot;
        this.vaultExperience = vaultExperience;
        this.vaultCrystalMode = vaultCrystalMode;
        this.noResearchTeamPenalty = noResearchTeamPenalty;
        this.allowMentorBrew = allowMentorBrew;
        this.allowKnowledgeBrew = allowKnowledgeBrew;
        this.boostPenalty = boostPenalty;
        this.vaultLock = vaultLock;
        this.vaultPartyExpSharing = vaultPartyExpSharing;
        this.vaultCrystalRecipeScaling = vaultCrystalRecipeScaling;
        this.spectatorMode = spectatorMode;
        this.spectatorPartyOnly = spectatorPartyOnly;
        this.partyMapSharing = partyMapSharing;
        this.locker = locker;
    }

    public static void encode(VaultRulesUpdateMessage message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.joinRequireParty);
        buffer.writeInt(message.vaultTimer);
        buffer.writeBoolean(message.allowWaypoints);
        buffer.m_130070_(message.vaultMode);
        buffer.m_130070_(message.vaultLoot);
        buffer.m_130070_(message.vaultExperience);
        buffer.m_130070_(message.vaultCrystalMode);
        buffer.writeBoolean(message.noResearchTeamPenalty);
        buffer.writeBoolean(message.allowMentorBrew);
        buffer.writeBoolean(message.allowKnowledgeBrew);
        buffer.writeBoolean(message.boostPenalty);
        buffer.writeInt(message.vaultLock);
        buffer.m_130070_(message.vaultPartyExpSharing);
        buffer.m_130070_(message.vaultCrystalRecipeScaling);
        buffer.m_130070_(message.spectatorMode);
        buffer.writeBoolean(message.spectatorPartyOnly);
        buffer.writeBoolean(message.partyMapSharing);
        buffer.writeBoolean(message.locker);
    }

    public static VaultRulesUpdateMessage decode(FriendlyByteBuf buffer) {
        return new VaultRulesUpdateMessage(buffer.readBoolean(), buffer.readInt(), buffer.readBoolean(), buffer.m_130277_(), buffer.m_130277_(), buffer.m_130277_(), buffer.m_130277_(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean(), buffer.readInt(), buffer.m_130277_(), buffer.m_130277_(), buffer.m_130277_(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean());
    }

    public static void handle(VaultRulesUpdateMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            MinecraftServer server = player.m_20194_();
            if (server == null) {
                return;
            }
            if (player.m_20310_(2) || server.m_129792_()) {
                ServerLevel world = server.m_129880_(Level.f_46428_);
                if (world == null) {
                    return;
                }
                GameRules gameRules = world.m_46469_();
                GameRules.BooleanValue joinPartyRule = (GameRules.BooleanValue)gameRules.m_46170_(ModGameRules.JOIN_REQUIRE_PARTY);
                joinPartyRule.m_46246_(message.isJoinRequireParty(), server);
                GameRules.IntegerValue timerRule = (GameRules.IntegerValue)gameRules.m_46170_(ModGameRules.VAULT_TIMER);
                timerRule.m_151489_(message.getVaultTimer(), server);
                GameRules.BooleanValue waypointsRule = (GameRules.BooleanValue)gameRules.m_46170_(ModGameRules.ALLOW_WAYPOINTS);
                waypointsRule.m_46246_(message.isAllowWaypoints(), server);
                VaultMode.GameRuleValue modeRule = (VaultMode.GameRuleValue)gameRules.m_46170_(ModGameRules.MODE);
                modeRule.setMode(message.getVaultMode(), server);
                VaultLoot.GameRuleValue lootRule = (VaultLoot.GameRuleValue)gameRules.m_46170_(ModGameRules.LOOT);
                lootRule.setMode(message.getVaultLoot(), server);
                VaultExperience.GameRuleValue expRule = (VaultExperience.GameRuleValue)gameRules.m_46170_(ModGameRules.EXPERIENCE);
                expRule.setMode(message.getVaultExperience(), server);
                VaultCrystalMode.GameRuleValue crystalRule = (VaultCrystalMode.GameRuleValue)gameRules.m_46170_(ModGameRules.CRYSTAL_MODE);
                crystalRule.setMode(message.getVaultCrystalMode(), server);
                GameRules.BooleanValue noResearchPenaltyRule = (GameRules.BooleanValue)gameRules.m_46170_(ModGameRules.NO_RESEARCH_TEAM_PENALTY);
                noResearchPenaltyRule.m_46246_(message.isNoResearchTeamPenalty(), server);
                GameRules.BooleanValue allowMentorBrewRule = (GameRules.BooleanValue)gameRules.m_46170_(ModGameRules.ALLOW_MENTOR_BREW);
                allowMentorBrewRule.m_46246_(message.isAllowMentorBrew(), server);
                GameRules.BooleanValue allowKnowledgeBrewRule = (GameRules.BooleanValue)gameRules.m_46170_(ModGameRules.ALLOW_KNOWLEDGE_BREW);
                allowKnowledgeBrewRule.m_46246_(message.isAllowKnowledgeBrew(), server);
                GameRules.BooleanValue boostPenaltyRule = (GameRules.BooleanValue)gameRules.m_46170_(ModGameRules.BOOST_PENALTY);
                boostPenaltyRule.m_46246_(message.isBoostPenalty(), server);
                GameRules.IntegerValue lockRule = (GameRules.IntegerValue)gameRules.m_46170_(ModGameRules.LEVEL_LOCK);
                lockRule.m_151489_(message.getVaultLock(), server);
                VaultPartyExpSharing.GameRuleValue partyExpSharingRule = (VaultPartyExpSharing.GameRuleValue)gameRules.m_46170_(ModGameRules.PARTY_EXP_SHARING);
                partyExpSharingRule.setMode(message.getVaultPartyExpSharing(), server);
                VaultCrystalRecipeScaling.GameRuleValue crystalRecipeScalingRule = (VaultCrystalRecipeScaling.GameRuleValue)gameRules.m_46170_(ModGameRules.CRYSTAL_RECIPE_SCALING);
                crystalRecipeScalingRule.setMode(message.getVaultCrystalRecipeScaling(), server);
                SpectatorMode.GameRuleValue spectatorRule = (SpectatorMode.GameRuleValue)gameRules.m_46170_(ModGameRules.SPECTATOR_MODE);
                spectatorRule.setMode(message.getSpectatorMode(), server);
                GameRules.BooleanValue spectatorPartyRule = (GameRules.BooleanValue)gameRules.m_46170_(ModGameRules.SPECTATOR_PARTY_ONLY);
                spectatorPartyRule.m_46246_(message.isSpectatorPartyOnly(), server);
                GameRules.BooleanValue partyMapRule = (GameRules.BooleanValue)gameRules.m_46170_(ModGameRules.PARTY_MAP_SHARING);
                partyMapRule.m_46246_(message.isPartyMapSharing(), server);
                GameRules.BooleanValue lockerRule = (GameRules.BooleanValue)gameRules.m_46170_(ModGameRules.LOCKER);
                lockerRule.m_46246_(message.isLocker(), server);
            }
        });
        context.setPacketHandled(true);
    }

    public boolean isJoinRequireParty() {
        return this.joinRequireParty;
    }

    public int getVaultTimer() {
        return this.vaultTimer;
    }

    public boolean isAllowWaypoints() {
        return this.allowWaypoints;
    }

    public String getVaultMode() {
        return this.vaultMode;
    }

    public String getVaultLoot() {
        return this.vaultLoot;
    }

    public String getVaultExperience() {
        return this.vaultExperience;
    }

    public String getVaultCrystalMode() {
        return this.vaultCrystalMode;
    }

    public boolean isNoResearchTeamPenalty() {
        return this.noResearchTeamPenalty;
    }

    public boolean isAllowMentorBrew() {
        return this.allowMentorBrew;
    }

    public boolean isAllowKnowledgeBrew() {
        return this.allowKnowledgeBrew;
    }

    public boolean isBoostPenalty() {
        return this.boostPenalty;
    }

    public int getVaultLock() {
        return this.vaultLock;
    }

    public String getVaultPartyExpSharing() {
        return this.vaultPartyExpSharing;
    }

    public String getVaultCrystalRecipeScaling() {
        return this.vaultCrystalRecipeScaling;
    }

    public String getSpectatorMode() {
        return this.spectatorMode;
    }

    public boolean isSpectatorPartyOnly() {
        return this.spectatorPartyOnly;
    }

    public boolean isPartyMapSharing() {
        return this.partyMapSharing;
    }

    public boolean isLocker() {
        return this.locker;
    }
}

