/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.container.VoidCrucibleContainer;
import iskallia.vault.world.data.VoidStoneBlacklistData;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class VoidCrucibleGhostSlotMessage {
    private final ItemStack stack;
    private final int slotNumber;

    public VoidCrucibleGhostSlotMessage(ItemStack stack, int slotNumber) {
        this.stack = stack;
        this.slotNumber = slotNumber;
    }

    public static void encode(VoidCrucibleGhostSlotMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130055_(msg.stack);
        packetBuffer.writeShort(msg.slotNumber);
    }

    public static VoidCrucibleGhostSlotMessage decode(FriendlyByteBuf packetBuffer) {
        return new VoidCrucibleGhostSlotMessage(packetBuffer.m_130267_(), packetBuffer.readShort());
    }

    public static void handle(VoidCrucibleGhostSlotMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> VoidCrucibleGhostSlotMessage.handleMessage(msg, context.getSender()));
        context.setPacketHandled(true);
    }

    private static void handleMessage(VoidCrucibleGhostSlotMessage msg, @Nullable ServerPlayer sender) {
        if (sender == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = sender.f_36096_;
        if (abstractContainerMenu instanceof VoidCrucibleContainer.Blacklist) {
            VoidCrucibleContainer.Blacklist blacklistContainer = (VoidCrucibleContainer.Blacklist)abstractContainerMenu;
            if (msg.stack.m_41720_().getRegistryName() == null) {
                return;
            }
            if (blacklistContainer.getBlacklistSize() < 54 && !blacklistContainer.getBlacklist().contains(msg.stack.m_41720_().getRegistryName())) {
                VoidStoneBlacklistData data = VoidStoneBlacklistData.get(sender.m_183503_());
                data.addBlacklist(sender, msg.stack.m_41720_().getRegistryName());
                blacklistContainer.updateVisibleItems();
                blacklistContainer.m_38946_();
            }
        }
    }
}

