/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message.quest;

import iskallia.vault.config.quest.QuestConfig;
import iskallia.vault.quest.QuestState;
import iskallia.vault.quest.base.Quest;
import iskallia.vault.world.data.QuestStatesData;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class QuestProgressMessage {
    private final String questId;

    public QuestProgressMessage(String questId) {
        this.questId = questId;
    }

    public String getQuestId() {
        return this.questId;
    }

    public static void encode(QuestProgressMessage pkt, FriendlyByteBuf buffer) {
        String questId = pkt.getQuestId();
        buffer.m_130070_(questId);
    }

    public static QuestProgressMessage decode(FriendlyByteBuf buffer) {
        String state = buffer.m_130277_();
        return new QuestProgressMessage(state);
    }

    public static void handle(QuestProgressMessage pkt, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        QuestState state = QuestStatesData.get().getState(player);
        Optional quest = ((QuestConfig)state.getConfig(player.m_183503_())).getQuestById(pkt.getQuestId());
        quest.ifPresent(q -> state.addProgress((Quest)q, 1.0f));
        context.setPacketHandled(true);
    }
}

