/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message.quest;

import iskallia.vault.client.gui.framework.screen.layout.ScreenLayout;
import iskallia.vault.client.gui.screen.quest.QuestOverviewElementScreen;
import iskallia.vault.quest.QuestState;
import iskallia.vault.quest.client.ClientQuestState;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class QuestSyncMessage {
    private final QuestState state;

    public QuestSyncMessage(QuestState state) {
        this.state = state;
    }

    public QuestState getState() {
        return this.state;
    }

    public static void encode(QuestSyncMessage pkt, FriendlyByteBuf buffer) {
        QuestState state = pkt.getState();
        buffer.m_130077_(state.getPlayerId());
        buffer.m_130079_(state.serializeNBT());
    }

    public static QuestSyncMessage decode(FriendlyByteBuf buffer) {
        UUID playerId = buffer.m_130259_();
        CompoundTag stateData = buffer.m_130260_();
        QuestState state = new QuestState(playerId);
        state.deserializeNBT(stateData);
        return new QuestSyncMessage(state);
    }

    public static void handle(QuestSyncMessage pkt, Supplier<NetworkEvent.Context> contextSupplier) {
        ClientQuestState.INSTANCE.updateState(pkt.getState());
        QuestSyncMessage.refreshScreen();
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void refreshScreen() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof QuestOverviewElementScreen) {
            QuestOverviewElementScreen screen2 = (QuestOverviewElementScreen)screen;
            screen2.refreshScreen();
            ScreenLayout.requestLayout();
        }
    }
}

