/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message.transmog;

import iskallia.vault.block.TransmogTableBlock;
import iskallia.vault.container.TransmogTableContainer;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.util.CoinDefinition;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.world.data.DiscoveredModelsData;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public record TransmogButtonMessage() {
    private static final TransmogButtonMessage instance = new TransmogButtonMessage();

    public static void encode(TransmogButtonMessage message, FriendlyByteBuf buffer) {
    }

    public static TransmogButtonMessage decode(FriendlyByteBuf buffer) {
        return instance;
    }

    public static void handle(TransmogButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            AbstractContainerMenu patt1631$temp = sender.f_36096_;
            if (patt1631$temp instanceof TransmogTableContainer) {
                TransmogTableContainer container = (TransmogTableContainer)patt1631$temp;
                if (sender != null && !container.getPreviewItemStack().m_41619_() && (container.priceFulfilled() || CoinDefinition.hasEnoughCurrency(InventoryUtil.findAllItems((Player)sender), new ItemStack((ItemLike)ModBlocks.VAULT_BRONZE, container.copperCost())))) {
                    Slot gearSlot = container.m_38853_(container.getInternalInventoryIndexRange().getContainerIndex(0));
                    VaultGearData initialData = VaultGearData.read(gearSlot.m_7993_());
                    if (!initialData.isModifiable()) {
                        return;
                    }
                    Slot bronzeSlot = container.m_38853_(container.getInternalInventoryIndexRange().getContainerIndex(1));
                    Slot outputSlot = container.m_38853_(container.getInternalInventoryIndexRange().getContainerIndex(container.getInternalInventory().outputSlotIndex()));
                    int copperCost = container.copperCost();
                    DiscoveredModelsData discoveredModelsData = DiscoveredModelsData.get((ServerLevel)sender.f_19853_);
                    Set<ResourceLocation> discoveredModels = discoveredModelsData.getDiscoveredModels(sender.m_142081_());
                    if (!TransmogTableBlock.canTransmogModel((Player)sender, discoveredModels, container.getSelectedModelId())) {
                        return;
                    }
                    ItemStack resultingStack = gearSlot.m_7993_().m_41777_();
                    VaultGearData gearData = VaultGearData.read(resultingStack);
                    gearData.createOrReplaceAttributeValue(ModGearAttributes.GEAR_MODEL, container.getSelectedModelId());
                    gearData.write(resultingStack);
                    gearSlot.m_5852_(ItemStack.f_41583_);
                    if (bronzeSlot.m_7993_().m_41613_() < copperCost) {
                        int remaining = copperCost - bronzeSlot.m_7993_().m_41613_();
                        container.getInternalInventory().m_6836_(1, ItemStack.f_41583_);
                        Optional<CoinDefinition> coinDefinition = CoinDefinition.getCoinDefinition((Item)ModBlocks.VAULT_BRONZE);
                        if (coinDefinition.isEmpty()) {
                            return;
                        }
                        CoinDefinition.deductCoins(InventoryUtil.findAllItems((Player)sender), remaining, coinDefinition.get());
                    } else {
                        ItemStack bronze = bronzeSlot.m_7993_().m_41777_();
                        bronze.m_41774_(copperCost);
                        container.getInternalInventory().m_6836_(1, bronze);
                    }
                    outputSlot.m_5852_(resultingStack);
                    container.m_38946_();
                }
            }
        });
        context.setPacketHandled(true);
    }
}

