/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.options;

import com.google.gson.JsonElement;
import iskallia.vault.core.data.adapter.IJsonAdapter;
import iskallia.vault.core.data.serializable.IJsonSerializable;
import iskallia.vault.options.VaultOptionsRegistry;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public class VaultOption<T>
implements IJsonSerializable<JsonElement> {
    private final ResourceLocation key;
    private final T defaultValue;
    private T value;
    private final Consumer<T> onChange;
    private final IJsonAdapter<T, JsonElement, Object> adapter;

    public VaultOption(ResourceLocation key, T defaultValue, Consumer<T> onChange, IJsonAdapter<T, JsonElement, Object> adapter) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.onChange = onChange;
        this.adapter = adapter;
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getValue() {
        return this.value != null ? this.value : this.defaultValue;
    }

    public void setValue(T value) {
        this.value = value;
        if (this.onChange != null) {
            this.onChange.accept(value);
        }
        VaultOptionsRegistry.saveOptions();
    }

    public void resetToDefault() {
        this.value = this.defaultValue;
        if (this.onChange != null) {
            this.onChange.accept(this.defaultValue);
        }
        VaultOptionsRegistry.saveOptions();
    }

    void loadValue(T value) {
        this.value = value;
        if (this.onChange != null) {
            this.onChange.accept(value);
        }
    }

    @Override
    public Optional<JsonElement> writeJson() {
        return this.adapter.writeJson(this.value, null);
    }

    @Override
    public void readJson(JsonElement json) {
        this.value = this.adapter.readJson(json, null).orElse(this.defaultValue);
    }
}

