/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.options;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.IJsonAdapter;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.init.ModOptions;
import iskallia.vault.options.VaultOption;
import iskallia.vault.util.ColorOption;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public class VaultOptionsRegistry {
    private static final Map<ResourceLocation, VaultOption<?>> options = new HashMap();
    private static final Map<String, OptionFile> FILES = new LinkedHashMap<String, OptionFile>();
    private static final String DEFAULT_OPTIONS_FILE = "vaultOptions.json";
    private static final String OPTIONS_FILE = "vaultOptions.json";

    public static <T> VaultOption<T> register(String fileName, ResourceLocation key, T defaultValue, Consumer<T> onChange, IJsonAdapter<T, JsonElement, Object> adapter) {
        if (options.containsKey(key)) {
            VaultMod.LOGGER.error("Vault Options attempted to register option with key: '{}' but it is already registered.", (Object)key);
            throw new IllegalArgumentException("Option with key " + String.valueOf(key) + " is already registered.");
        }
        OptionFile optionFile = FILES.computeIfAbsent(fileName, OptionFile::new);
        VaultOption<T> option = new VaultOption<T>(key, defaultValue, onChange, adapter);
        options.put(key, option);
        optionFile.options.put(key, option);
        return option;
    }

    public static <T> VaultOption<T> registerDefaultFile(ResourceLocation key, T defaultValue, Consumer<T> onChange, IJsonAdapter<T, JsonElement, Object> adapter) {
        return VaultOptionsRegistry.register("vaultOptions.json", key, defaultValue, onChange, adapter);
    }

    public static <T> VaultOption<T> registerDefaultFile(ResourceLocation key, T defaultValue, IJsonAdapter<T, JsonElement, Object> adapter) {
        return VaultOptionsRegistry.registerDefaultFile(key, defaultValue, null, adapter);
    }

    public static <T> VaultOption<T> register(String fileName, ResourceLocation key, T defaultValue, IJsonAdapter<T, JsonElement, Object> adapter) {
        return VaultOptionsRegistry.register(fileName, key, defaultValue, null, adapter);
    }

    public static VaultOption<Float> registerFloat(ResourceLocation key, float defaultValue, Consumer<Float> onChange) {
        return VaultOptionsRegistry.registerDefaultFile(key, Float.valueOf(defaultValue), onChange, Adapters.FLOAT);
    }

    public static VaultOption<Float> registerFloat(ResourceLocation key, float defaultValue) {
        return VaultOptionsRegistry.registerFloat(key, defaultValue, null);
    }

    public static VaultOption<Boolean> registerBoolean(ResourceLocation key, boolean defaultValue, Consumer<Boolean> onChange) {
        return VaultOptionsRegistry.registerDefaultFile(key, defaultValue, onChange, Adapters.BOOLEAN);
    }

    public static VaultOption<Boolean> registerBoolean(ResourceLocation key, boolean defaultValue) {
        return VaultOptionsRegistry.registerBoolean(key, defaultValue, null);
    }

    public static VaultOption<Integer> registerInteger(ResourceLocation key, int defaultValue) {
        return VaultOptionsRegistry.registerDefaultFile(key, defaultValue, Adapters.INT);
    }

    public static VaultOption<Long> registerLong(ResourceLocation key, long defaultValue) {
        return VaultOptionsRegistry.registerDefaultFile(key, defaultValue, Adapters.LONG);
    }

    public static VaultOption<Double> registerDouble(ResourceLocation key, double defaultValue) {
        return VaultOptionsRegistry.registerDefaultFile(key, defaultValue, Adapters.DOUBLE);
    }

    public static VaultOption<String> registerString(ResourceLocation key, String defaultValue) {
        return VaultOptionsRegistry.registerDefaultFile(key, defaultValue, Adapters.UTF_8);
    }

    public static <E extends Enum<E>> VaultOption<E> registerEnum(ResourceLocation key, E defaultValue) {
        return VaultOptionsRegistry.registerDefaultFile(key, defaultValue, Adapters.ofEnum(defaultValue.getDeclaringClass(), EnumAdapter.Mode.NAME));
    }

    public static VaultOption<ResourceLocation> registerResourceLocation(ResourceLocation key, ResourceLocation defaultValue) {
        return VaultOptionsRegistry.registerDefaultFile(key, defaultValue, Adapters.IDENTIFIER);
    }

    public static VaultOption<ColorOption> registerHunterColour(ResourceLocation key, ColorOption.HunterSpec hunterSpec, float defaultRed, float defaultGreen, float defaultBlue) {
        return VaultOptionsRegistry.registerDefaultFile(key, new ColorOption(hunterSpec, defaultRed, defaultGreen, defaultBlue), ColorOption.ADAPTER);
    }

    public static void loadOptions() {
        boolean missingAny = false;
        for (OptionFile optionFile : FILES.values()) {
            File file = optionFile.getFile();
            if (!file.exists()) {
                missingAny = true;
                continue;
            }
            try {
                BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);
                try {
                    JsonObject json = (JsonObject)Config.GSON.fromJson((Reader)reader, JsonObject.class);
                    if (json == null) continue;
                    JsonObject values = json.has("options") && json.get("options").isJsonObject() ? json.getAsJsonObject("options") : json;
                    for (Map.Entry entry : values.entrySet()) {
                        if ("version".equals(entry.getKey())) {
                            if (ModOptions.getOptionsVersion() <= ((JsonElement)entry.getValue()).getAsInt()) continue;
                            continue;
                        }
                        ResourceLocation key = new ResourceLocation((String)entry.getKey());
                        VaultOption<?> option = options.get(key);
                        if (option == null) continue;
                        try {
                            option.readJson((JsonElement)entry.getValue());
                        }
                        catch (Exception e) {
                            VaultMod.LOGGER.error("Failed to deserialize Vault option '{}'", (Object)key, (Object)e);
                            option.loadValue(option.getDefaultValue());
                        }
                    }
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (IOException e) {
                VaultMod.LOGGER.error("Failed to load Vault options from file '{}'", (Object)file.getName(), (Object)e);
            }
        }
        if (missingAny) {
            VaultOptionsRegistry.saveOptions();
        }
    }

    public static void saveOptions() {
        for (OptionFile optionFile : FILES.values()) {
            if (optionFile.options.isEmpty()) continue;
            JsonObject root = new JsonObject();
            root.addProperty("version", (Number)ModOptions.getOptionsVersion());
            JsonObject values = new JsonObject();
            for (Map.Entry<ResourceLocation, VaultOption<?>> entry : optionFile.options.entrySet()) {
                VaultOption<?> option = entry.getValue();
                JsonElement serialized = option.writeJson().orElse((JsonElement)JsonNull.INSTANCE);
                values.add(entry.getKey().toString(), serialized);
            }
            root.add("options", (JsonElement)values);
            File file = optionFile.getFile();
            try {
                if (file.getParentFile() != null) {
                    Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
                }
                BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
                try {
                    Config.GSON.toJson((JsonElement)root, (Appendable)writer);
                }
                finally {
                    if (writer == null) continue;
                    ((Writer)writer).close();
                }
            }
            catch (IOException e) {
                VaultMod.LOGGER.error("Failed to save Vault options to file '{}'", (Object)file.getName(), (Object)e);
            }
        }
    }

    private static class OptionFile {
        private final String fileName;
        private final Map<ResourceLocation, VaultOption<?>> options = new LinkedHashMap();

        private OptionFile(String fileName) {
            this.fileName = fileName;
        }

        private File getFile() {
            return new File(this.fileName);
        }
    }
}

