/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.quest;

import com.google.common.collect.ImmutableSet;
import iskallia.vault.config.quest.QuestConfig;
import iskallia.vault.core.SkyVaultsChunkGenerator;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ClientboundToastMessage;
import iskallia.vault.network.message.quest.QuestSyncMessage;
import iskallia.vault.quest.base.Quest;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.nbt.NBTHelper;
import iskallia.vault.world.data.QuestStatesData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public class QuestState
implements INBTSerializable<CompoundTag> {
    protected UUID playerId;
    protected Map<String, Float> inProgress = new HashMap<String, Float>();
    protected Set<String> readyToComplete = new HashSet<String>();
    protected Set<String> completed = new HashSet<String>();
    private boolean isSkyVaultWorld;

    public QuestState(UUID playerId) {
        this.playerId = playerId;
    }

    public QuestState(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public void initialize() {
        if (this.getServerPlayer() == null) {
            return;
        }
        ServerLevel serverLevel = this.getServerPlayer().m_183503_();
        QuestStatesData questStatesData = QuestStatesData.get();
        if (questStatesData.isSkyVaultWorld() || SkyVaultsChunkGenerator.matches((Level)serverLevel)) {
            this.isSkyVaultWorld = true;
        }
        if (!this.isInitialized()) {
            EntityHelper.giveItem((Player)this.getServerPlayer(), ModItems.QUEST_BOOK.m_7968_());
            ((QuestConfig)this.getConfig(serverLevel)).getQuests().stream().filter(quest -> quest.getUnlockedBy().isEmpty()).forEach(this::setInProgress);
        }
        this.removeMissingQuests(this.getServerPlayer());
        this.addNewQuests(this.getServerPlayer());
        if (serverLevel.m_46469_().m_46207_(ModGameRules.QUEST_EXPERT_MODE)) {
            this.setExpertMode(serverLevel);
        }
        this.syncAndPersist();
    }

    private void removeMissingQuests(ServerPlayer player) {
        ServerLevel level = player.m_20194_().m_129783_();
        Object config = this.getConfig(level);
        for (String questId : this.getAllQuestIds()) {
            if (!((QuestConfig)config).getQuestById(questId).isEmpty()) continue;
            this.removeQuest(questId);
            this.syncAndPersist();
        }
        if (this.getInProgress().isEmpty() && this.getReadyToComplete().isEmpty()) {
            this.updateMissingInProgress(level);
        }
    }

    private void updateMissingInProgress(ServerLevel level) {
        List<Quest> quests = ((QuestConfig)this.getConfig(level)).getQuests().stream().filter(quest -> !this.getInProgress().contains((Object)quest.getId())).filter(quest -> !this.getReadyToComplete().contains((Object)quest.getId())).filter(quest -> !this.getCompleted().contains((Object)quest.getId())).filter(quest -> quest.getUnlockedBy().isEmpty() || this.getCompleted().contains((Object)quest.getUnlockedBy())).toList();
        if (quests.isEmpty()) {
            throw new IllegalStateException("There is no quest which is eligible to be set in progress. This is a config issue. Report to Devs.");
        }
        quests.forEach(this::setInProgress);
        this.syncAndPersist();
    }

    private void removeQuest(String questId) {
        this.inProgress.remove(questId);
        this.readyToComplete.remove(questId);
        this.completed.remove(questId);
    }

    private Collection<String> getAllQuestIds() {
        ArrayList<String> quests = new ArrayList<String>();
        quests.addAll((Collection<String>)this.getInProgress());
        quests.addAll((Collection<String>)this.getReadyToComplete());
        quests.addAll((Collection<String>)this.getCompleted());
        return quests;
    }

    private void addNewQuests(ServerPlayer serverPlayer) {
        Object config = this.getConfig(serverPlayer.m_183503_());
        ((QuestConfig)config).getQuests().stream().filter(quest -> {
            if (this.getCompleted().contains((Object)quest.getUnlockedBy())) {
                return !this.getCompleted().contains((Object)quest.getId()) && !this.getReadyToComplete().contains((Object)quest.getId()) && !this.getInProgress().contains((Object)quest.getId());
            }
            return false;
        }).forEach(this::setInProgress);
    }

    public void setExpertMode(ServerLevel level) {
        Object config = this.getConfig(level);
        Collection<Quest> quests = ((QuestConfig)config).getQuests();
        for (Quest quest : quests) {
            if (this.isQuestActivated(quest.getId())) continue;
            this.setInProgress(quest);
        }
        this.syncAndPersist();
    }

    private boolean isQuestActivated(String questId) {
        return this.getCompleted().contains((Object)questId) || this.getReadyToComplete().contains((Object)questId) || this.getInProgress().contains((Object)questId);
    }

    public <C extends QuestConfig> C getConfig(ServerLevel level) {
        QuestStatesData data = QuestStatesData.get();
        if (data.isSkyVaultWorld() || SkyVaultsChunkGenerator.matches((Level)level)) {
            this.isSkyVaultWorld = true;
            return (C)ModConfigs.SKY_QUESTS;
        }
        return (C)ModConfigs.QUESTS;
    }

    public boolean isInitialized() {
        return !this.getInProgress().isEmpty() || !this.getReadyToComplete().isEmpty() || !this.getCompleted().isEmpty();
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public boolean isSkyVaultWorld() {
        return this.isSkyVaultWorld;
    }

    @Nullable
    private ServerPlayer getServerPlayer() {
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.playerId);
    }

    public ImmutableSet<String> getInProgress() {
        return ImmutableSet.copyOf(this.inProgress.keySet());
    }

    public ImmutableSet<String> getReadyToComplete() {
        return ImmutableSet.copyOf(this.readyToComplete);
    }

    public ImmutableSet<String> getCompleted() {
        return ImmutableSet.copyOf(this.completed);
    }

    public void setInProgress(Quest quest) {
        this.inProgress.put(quest.getId(), Float.valueOf(0.0f));
        this.syncAndPersist();
    }

    private void setReadyToComplete(Quest quest) {
        this.inProgress.remove(quest.getId());
        this.readyToComplete.add(quest.getId());
        if (this.getServerPlayer() != null) {
            ModNetwork.CHANNEL.sendTo((Object)new ClientboundToastMessage(quest.getName(), "You have completed a quest!", quest.getIcon()), this.getServerPlayer().f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public void setComplete(Quest quest) {
        ServerPlayer serverPlayer = this.getServerPlayer();
        if (serverPlayer == null) {
            return;
        }
        String id = quest.getId();
        if (!this.readyToComplete.contains(id)) {
            return;
        }
        this.readyToComplete.remove(id);
        this.completed.add(id);
        List<Quest> nextQuests = ((QuestConfig)this.getConfig(serverPlayer.m_183503_())).getNextQuests(quest);
        for (Quest nextQuest : nextQuests) {
            if (this.getInProgress().contains((Object)nextQuest.getId()) || this.getReadyToComplete().contains((Object)nextQuest.getId()) || this.getCompleted().contains((Object)nextQuest.getId())) continue;
            this.setInProgress(nextQuest);
        }
        quest.getReward().apply(serverPlayer);
        this.syncAndPersist();
    }

    public void addProgress(Quest quest, float amount) {
        String id = quest.getId();
        if (!this.inProgress.containsKey(id)) {
            return;
        }
        float progress = this.inProgress.merge(id, Float.valueOf(amount), (currentAmount, newAmount) -> Float.valueOf(Math.min(currentAmount.floatValue() + newAmount.floatValue(), quest.getTargetProgress()))).floatValue();
        if (progress >= quest.getTargetProgress()) {
            this.setReadyToComplete(quest);
        }
        this.syncAndPersist();
    }

    public void syncAndPersist() {
        QuestStatesData questStatesData = QuestStatesData.get();
        questStatesData.m_77762_();
        if (this.getServerPlayer() == null) {
            return;
        }
        ModNetwork.CHANNEL.sendTo((Object)new QuestSyncMessage(this), this.getServerPlayer().f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        CompoundTag inProgressTag = new CompoundTag();
        for (String key : this.inProgress.keySet()) {
            inProgressTag.m_128350_(key, this.inProgress.get(key).floatValue());
        }
        NBTHelper.writeCollection(tag, "Completed", this.completed, StringTag.class, StringTag::m_129297_);
        NBTHelper.writeCollection(tag, "ReadyToComplete", this.readyToComplete, StringTag.class, StringTag::m_129297_);
        tag.m_128365_("InProgress", (Tag)inProgressTag);
        tag.m_128379_("isSkyVaultWorld", this.isSkyVaultWorld);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.completed.clear();
        this.readyToComplete.clear();
        this.inProgress.clear();
        NBTHelper.readCollection(tag, "Completed", StringTag.class, StringTag::m_7916_, this.completed);
        NBTHelper.readCollection(tag, "ReadyToComplete", StringTag.class, StringTag::m_7916_, this.readyToComplete);
        CompoundTag inProgressTag = tag.m_128469_("InProgress");
        for (String key : inProgressTag.m_128431_()) {
            this.inProgress.put(key, Float.valueOf(inProgressTag.m_128457_(key)));
        }
        this.isSkyVaultWorld = tag.m_128471_("isSkyVaultWorld");
    }

    public void reset() {
        this.completed.clear();
        this.readyToComplete.clear();
        this.inProgress.clear();
        this.initialize();
    }

    public void setSkyVaultWorld(boolean enabled) {
        this.isSkyVaultWorld = enabled;
        QuestStatesData questStatesData = QuestStatesData.get();
        questStatesData.m_77762_();
        if (this.getServerPlayer() == null) {
            return;
        }
        ModNetwork.CHANNEL.sendTo((Object)new QuestSyncMessage(this), this.getServerPlayer().f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

