/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.quest.type;

import iskallia.vault.block.base.GodAltarTileEntity;
import iskallia.vault.config.entry.DescriptionData;
import iskallia.vault.quest.base.Quest;
import iskallia.vault.world.data.QuestStatesData;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockInteractionQuest
extends Quest {
    public static final String BLOCK_INTERACT = "block_interact";

    public BlockInteractionQuest(String id, String name, DescriptionData descriptionData, ResourceLocation icon, ResourceLocation targetId, float targetProgress, String unlockedBy, Quest.QuestReward reward) {
        super(BLOCK_INTERACT, id, name, descriptionData, icon, targetId, targetProgress, unlockedBy, reward);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!QuestStatesData.get().getState(player2).getInProgress().contains((Object)this.id)) {
            return;
        }
        if (this.id.equals("complete_god_altar")) {
            BlockEntity blockEntity = player2.m_183503_().m_7702_(event.getPos());
            if (!(blockEntity instanceof GodAltarTileEntity)) {
                return;
            }
            GodAltarTileEntity altar = (GodAltarTileEntity)blockEntity;
            if (altar.isCompleted()) {
                this.progress(player2, 1.0f);
            }
        } else {
            Block activated;
            Block target = (Block)ForgeRegistries.BLOCKS.getValue(this.targetId);
            if (target != null && (activated = player2.m_183503_().m_8055_(event.getPos()).m_60734_()) == target) {
                this.progress(player2, 1.0f);
            }
        }
    }

    @Override
    public MutableComponent getTypeDescription() {
        return new TextComponent("Activate the target block");
    }
}

