/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.quest.type;

import com.google.common.collect.ImmutableSet;
import iskallia.vault.config.entry.DescriptionData;
import iskallia.vault.config.quest.QuestConfig;
import iskallia.vault.quest.base.Quest;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.world.data.QuestStatesData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class CollectionQuest
extends Quest {
    public static final String COLLECTION = "collection";

    public CollectionQuest(String id, String name, DescriptionData descriptionData, ResourceLocation icon, ResourceLocation targetId, float targetProgress, String unlockedBy, Quest.QuestReward reward) {
        super(COLLECTION, id, name, descriptionData, icon, targetId, targetProgress, unlockedBy, reward);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (sPlayer.f_19797_ % 20 == 0) {
            CollectionQuest.checkCollections(sPlayer);
        }
    }

    private static void checkCollections(ServerPlayer sPlayer) {
        ImmutableSet<String> inProgressQuests = QuestStatesData.get().getState(sPlayer).getInProgress();
        HashMap itemQuestMap = new HashMap();
        ((QuestConfig)QuestStatesData.get().getState(sPlayer).getConfig(sPlayer.m_183503_())).getQuests().stream().filter(quest -> inProgressQuests.contains(quest.getId())).filter(quest -> quest instanceof CollectionQuest).map(quest -> (CollectionQuest)quest).forEach(quest -> {
            Item target = (Item)ForgeRegistries.ITEMS.getValue(quest.targetId);
            if (target == null) {
                return;
            }
            itemQuestMap.computeIfAbsent(target, k -> new ArrayList()).add(quest);
        });
        HashMap<CollectionQuest, Integer> countMap = new HashMap<CollectionQuest, Integer>();
        InventoryUtil.findAllItems((Player)sPlayer).stream().map(InventoryUtil.ItemAccess::getStack).filter(stack -> itemQuestMap.containsKey(stack.m_41720_())).forEach(stack -> {
            List quests = (List)itemQuestMap.get(stack.m_41720_());
            if (quests == null) {
                return;
            }
            quests.forEach(quest -> {
                int existing = countMap.getOrDefault(quest, 0);
                countMap.put((CollectionQuest)quest, existing + stack.m_41613_());
            });
        });
        countMap.forEach((quest, count) -> {
            if ((float)count.intValue() >= quest.targetProgress) {
                quest.progress(sPlayer, count.intValue());
            }
        });
    }

    @Override
    public MutableComponent getTypeDescription() {
        return new TextComponent("Collect the item(s). When clicking 'Complete', the items must be in your inventory and are not consumed.");
    }
}

