/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.quest.type;

import iskallia.vault.config.entry.DescriptionData;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.QuestManager;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.StatsCollector;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.quest.base.InVaultQuest;
import iskallia.vault.quest.base.Quest;
import iskallia.vault.util.StringUtils;
import iskallia.vault.world.data.QuestStatesData;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class CompleteVaultQuest
extends InVaultQuest {
    public static final String COMPLETE_VAULT = "complete_vault";

    public CompleteVaultQuest(String id, String name, DescriptionData descriptionData, ResourceLocation icon, ResourceLocation targetId, float targetProgress, String unlockedBy, Quest.QuestReward reward) {
        super(COMPLETE_VAULT, id, name, descriptionData, icon, targetId, targetProgress, unlockedBy, reward);
    }

    @Override
    public void initServer(QuestManager manager, VirtualWorld world, Vault vault) {
        CommonEvents.LISTENER_LEAVE.register(manager, data -> data.getListener().getPlayer().ifPresent(serverPlayer -> {
            if (!QuestStatesData.get().getState((ServerPlayer)serverPlayer).getInProgress().contains((Object)this.id)) {
                return;
            }
            if (vault.has(Vault.STATS)) {
                String objective;
                StatsCollector statCollector = vault.get(Vault.STATS);
                StatCollector stats = statCollector.get(serverPlayer.m_142081_());
                if (stats == null) {
                    return;
                }
                if (!stats.has(StatCollector.COMPLETION)) {
                    return;
                }
                if (stats.getCompletion() == Completion.COMPLETED && (objective = vault.get(Vault.OBJECTIVES).get(Objectives.KEY)).equals(this.targetId.m_135815_())) {
                    this.progress((ServerPlayer)serverPlayer, 1.0f);
                }
            }
        }));
    }

    @Override
    public MutableComponent getTypeDescription() {
        return new TextComponent("Complete a " + StringUtils.convertToTitleCase(this.targetId.m_135815_()) + " Vault");
    }
}

