/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.quest.type;

import iskallia.vault.VaultMod;
import iskallia.vault.config.entry.DescriptionData;
import iskallia.vault.quest.base.Quest;
import iskallia.vault.world.data.PlayerVaultStatsData;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SpendPrestigePointQuest
extends Quest {
    public static final String SPEND_PRESTIGE_POINT = "spend_prestige_point";

    public SpendPrestigePointQuest(String id, String name, DescriptionData descriptionData, ResourceLocation icon, ResourceLocation targetId, float targetProgress, String unlockedBy, Quest.QuestReward reward) {
        super(SPEND_PRESTIGE_POINT, id, name, descriptionData, icon, targetId, targetProgress, unlockedBy, reward);
    }

    @SubscribeEvent
    public void checkPastLevel(TickEvent.PlayerTickEvent event) {
        int targetLevel;
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.f_19797_ % 100 != 0) {
            return;
        }
        int currentSpent = PlayerVaultStatsData.get(player2.m_183503_()).getVaultStats((Player)player2).getTotalSpentPrestigePoints();
        try {
            targetLevel = Integer.parseInt(this.targetId.m_135815_());
        }
        catch (NumberFormatException exception) {
            VaultMod.LOGGER.error("Attempted to parse a spent prestige points via ID in Level Up quest and the value was not a number. FIX IT (eg. \"the_vault:5\")");
            return;
        }
        if (currentSpent >= targetLevel) {
            this.progress(player2, 1.0f);
        }
    }

    @Override
    public MutableComponent getTypeDescription() {
        return new TextComponent("Spend Prestige Points");
    }
}

