/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.recipe;

import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class TimedCraftingRecipe
extends ShapedRecipe {
    @Nullable
    private final Instant startTime;
    @Nullable
    private final Instant endTime;

    private TimedCraftingRecipe(ShapedRecipe baseRecipe, @Nullable Instant startTime, @Nullable Instant endTime) {
        super(baseRecipe.m_6423_(), baseRecipe.m_6076_(), baseRecipe.getRecipeWidth(), baseRecipe.getRecipeHeight(), TimedCraftingRecipe.copyIngredients((NonNullList<Ingredient>)baseRecipe.m_7527_()), baseRecipe.m_8043_().m_41777_());
        this.startTime = startTime;
        this.endTime = endTime;
        if (this.startTime != null && this.endTime != null && this.startTime.isAfter(this.endTime)) {
            VaultMod.LOGGER.warn("Timed recipe {} will never be craftable because start_time is after end_time.", (Object)baseRecipe.m_6423_());
        }
    }

    private static NonNullList<Ingredient> copyIngredients(NonNullList<Ingredient> original) {
        NonNullList copy = NonNullList.m_122780_((int)original.size(), (Object)Ingredient.f_43901_);
        for (int i = 0; i < original.size(); ++i) {
            copy.set(i, (Object)((Ingredient)original.get(i)));
        }
        return copy;
    }

    public boolean m_5818_(@NotNull CraftingContainer container, @NotNull Level level) {
        if (!this.isActive()) {
            return false;
        }
        return super.m_5818_(container, level);
    }

    @NotNull
    public ItemStack m_5874_(@NotNull CraftingContainer container) {
        if (!this.isActive()) {
            return ItemStack.f_41583_;
        }
        return super.m_5874_(container);
    }

    private boolean isActive() {
        Instant now = Instant.now();
        if (this.startTime != null && now.isBefore(this.startTime)) {
            return false;
        }
        return this.endTime == null || !now.isAfter(this.endTime);
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<TimedCraftingRecipe> {
        private final ShapedRecipe.Serializer shapedSerializer = new ShapedRecipe.Serializer();

        public TimedCraftingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe base = this.shapedSerializer.m_6729_(recipeId, json);
            Instant start = Serializer.parseInstant(json, recipeId, "start_time");
            Instant end = Serializer.parseInstant(json, recipeId, "end_time");
            return new TimedCraftingRecipe(base, start, end);
        }

        @Nullable
        public TimedCraftingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapedRecipe base = this.shapedSerializer.m_8005_(recipeId, buffer);
            Instant start = Serializer.readInstant(buffer);
            Instant end = Serializer.readInstant(buffer);
            return new TimedCraftingRecipe(base, start, end);
        }

        public void toNetwork(FriendlyByteBuf buffer, TimedCraftingRecipe recipe) {
            this.shapedSerializer.m_6178_(buffer, (ShapedRecipe)recipe);
            Serializer.writeInstant(buffer, recipe.startTime);
            Serializer.writeInstant(buffer, recipe.endTime);
        }

        @Nullable
        private static Instant parseInstant(JsonObject json, ResourceLocation recipeId, String key) {
            if (!json.has(key)) {
                return null;
            }
            String value = GsonHelper.m_13851_((JsonObject)json, (String)key, (String)"");
            if (value.isBlank()) {
                return null;
            }
            try {
                return Instant.parse(value);
            }
            catch (DateTimeParseException e) {
                VaultMod.LOGGER.warn("Failed to parse {} '{}' for timed recipe {}.", (Object)key, (Object)value, (Object)recipeId);
                return null;
            }
        }

        private static void writeInstant(FriendlyByteBuf buffer, @Nullable Instant instant) {
            buffer.writeBoolean(instant != null);
            if (instant != null) {
                buffer.writeLong(instant.toEpochMilli());
            }
        }

        @Nullable
        private static Instant readInstant(FriendlyByteBuf buffer) {
            if (buffer.readBoolean()) {
                return Instant.ofEpochMilli(buffer.readLong());
            }
            return null;
        }
    }
}

