/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.research.type;

import com.google.gson.annotations.Expose;
import iskallia.vault.research.Restrictions;
import iskallia.vault.research.type.Research;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class ModResearch
extends Research {
    @Expose
    protected Set<String> modIds = new HashSet<String>();
    @Expose
    protected Restrictions restrictions = Restrictions.forMods();

    public ModResearch(String name, int cost, String ... modIds) {
        super(name, cost);
        Collections.addAll(this.modIds, modIds);
    }

    public Set<String> getModIds() {
        return this.modIds;
    }

    public Restrictions getRestrictions() {
        return this.restrictions;
    }

    public ModResearch withRestrictions(boolean hittability, boolean entityIntr, boolean blockIntr, boolean usability, boolean craftability) {
        this.restrictions.set(Restrictions.Type.HITTABILITY, hittability);
        this.restrictions.set(Restrictions.Type.ENTITY_INTERACTABILITY, entityIntr);
        this.restrictions.set(Restrictions.Type.BLOCK_INTERACTABILITY, blockIntr);
        this.restrictions.set(Restrictions.Type.USABILITY, usability);
        this.restrictions.set(Restrictions.Type.CRAFTABILITY, craftability);
        return this;
    }

    @Override
    public boolean restricts(ItemStack stack, Restrictions.Type restrictionType) {
        if (!this.restrictions.restricts(restrictionType)) {
            return false;
        }
        ResourceLocation registryName = stack.m_41720_().getRegistryName();
        if (registryName == null) {
            return false;
        }
        return this.modIds.contains(registryName.m_135827_());
    }

    @Override
    public boolean restricts(Block block, Restrictions.Type restrictionType) {
        if (!this.restrictions.restricts(restrictionType)) {
            return false;
        }
        ResourceLocation registryName = block.getRegistryName();
        if (registryName == null) {
            return false;
        }
        return this.modIds.contains(registryName.m_135827_());
    }

    @Override
    public boolean restricts(EntityType<?> entityType, Restrictions.Type restrictionType) {
        if (!this.restrictions.restricts(restrictionType)) {
            return false;
        }
        ResourceLocation registryName = entityType.getRegistryName();
        if (registryName == null) {
            return false;
        }
        return this.modIds.contains(registryName.m_135827_());
    }
}

