/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.VaultLevelMessage;
import iskallia.vault.util.NetcodeUtils;
import iskallia.vault.world.data.EternalsData;
import iskallia.vault.world.data.PlayerGreedData;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerVaultStats
implements INBTSerializable<CompoundTag> {
    public static final int VAULT_LEVELS_PER_EXPERTISE_POINT = 5;
    private final UUID uuid;
    private int vaultLevel;
    private int exp;
    private int unspentSkillPoints;
    private int unspentExpertisePoints;
    private int unspentKnowledgePoints;
    private int unspentArchetypePoints;
    private int unspentRegretPoints;
    private int unspentPrestigePoints;
    private int totalSpentSkillPoints;
    private int totalSpentExpertisePoints;
    private int totalSpentKnowledgePoints;
    private int totalSpentArchetypePoints;
    private int totalSpentRegretPoints;
    private int totalSpentPrestigePoints;

    public PlayerVaultStats(UUID uuid) {
        this.uuid = uuid;
    }

    public int getVaultLevel() {
        return Math.min(this.vaultLevel, 100);
    }

    public int getVaultUncappedLevel() {
        return this.vaultLevel;
    }

    public boolean isPrestige() {
        return this.vaultLevel > 100;
    }

    public int getPrestigeLevel() {
        return this.vaultLevel - 100;
    }

    public int getExp() {
        return this.exp;
    }

    public int getUnspentSkillPoints() {
        return this.unspentSkillPoints;
    }

    public int getUnspentExpertisePoints() {
        return this.unspentExpertisePoints;
    }

    public int getUnspentKnowledgePoints() {
        return this.unspentKnowledgePoints;
    }

    public int getUnspentArchetypePoints() {
        return this.unspentArchetypePoints;
    }

    public int getUnspentRegretPoints() {
        return this.unspentRegretPoints;
    }

    public int getUnspentPrestigePoints() {
        return this.unspentPrestigePoints;
    }

    public int getTotalSpentSkillPoints() {
        return this.totalSpentSkillPoints;
    }

    public int getTotalSpentKnowledgePoints() {
        return this.totalSpentKnowledgePoints;
    }

    public int getTotalSpentExpertisePoints() {
        return this.totalSpentExpertisePoints;
    }

    public int getTotalSpentArchetypePoints() {
        return this.totalSpentArchetypePoints;
    }

    public int getTotalSpentRegretPoints() {
        return this.totalSpentRegretPoints;
    }

    public int getTotalSpentPrestigePoints() {
        return this.totalSpentPrestigePoints;
    }

    public int getExpNeededToNextLevel() {
        if (this.getVaultLevel() >= 100) {
            return ModConfigs.LEVELS_META.getPrestigeTnl();
        }
        return ModConfigs.LEVELS_META.getLevelMeta((int)this.vaultLevel).tnl;
    }

    public void setVaultLevel(MinecraftServer server, int level) {
        this.vaultLevel = level;
        this.exp = 0;
        this.sync(server);
    }

    public void addVaultExp(MinecraftServer server, int exp) {
        int neededExp;
        int maxLevel = ModConfigs.LEVELS_META.getMaxLevel();
        if (this.getVaultLevel() < 100 && this.getVaultLevel() >= maxLevel) {
            return;
        }
        if (this.getVaultLevel() >= 100 && !PlayerGreedData.get(server).get(this.uuid).hasCompletedHerald()) {
            this.exp = 0;
            this.vaultLevel = 100;
            return;
        }
        this.exp = Math.max(this.exp, 0);
        this.exp += (int)((float)exp * ModConfigs.LEVELS_META.getExpMultiplier());
        int initialLevel = this.vaultLevel;
        while (this.exp >= (neededExp = this.getExpNeededToNextLevel())) {
            ++this.vaultLevel;
            if (this.vaultLevel > 100) {
                ++this.unspentPrestigePoints;
            } else {
                ++this.unspentSkillPoints;
                if (this.vaultLevel % 5 == 0) {
                    ++this.unspentExpertisePoints;
                }
            }
            this.exp -= neededExp;
        }
        if (this.vaultLevel > initialLevel) {
            NetcodeUtils.runIfPresent(server, this.uuid, this::fancyLevelUpEffects);
            ServerPlayer player = server.m_6846_().m_11259_(this.uuid);
            if (player != null) {
                player.refreshTabListName();
            }
            CommonEvents.VAULT_LEVEL_UP.invoke(player, exp, initialLevel, this.vaultLevel);
        }
        this.sync(server);
    }

    public int simulateXpIncrease(int exp) {
        int newLevel = this.vaultLevel;
        float newExp = (float)this.exp + (float)exp * ModConfigs.LEVELS_META.getExpMultiplier();
        while (true) {
            int n;
            int neededExp = this.getExpNeededToNextLevel();
            if (!(newExp >= (float)n)) break;
            ++newLevel;
            newExp -= (float)neededExp;
        }
        return newLevel;
    }

    protected void fancyLevelUpEffects(ServerPlayer player) {
        ServerLevel world = player.m_183503_();
        Vec3 pos = player.m_20182_();
        for (int i = 0; i < 20; ++i) {
            double d0 = world.f_46441_.nextGaussian();
            double d1 = world.f_46441_.nextGaussian();
            double d2 = world.f_46441_.nextGaussian();
            world.m_8767_((ParticleOptions)ParticleTypes.f_123767_, pos.m_7096_() + world.f_46441_.nextDouble() - 0.5, pos.m_7098_() + world.f_46441_.nextDouble() - 0.5 + 3.0, pos.m_7094_() + world.f_46441_.nextDouble() - 0.5, 10, d0, d1, d2, 0.25);
        }
        world.m_5594_(null, player.m_142538_(), ModSounds.VAULT_LEVEL_UP_SFX, SoundSource.PLAYERS, 1.0f, 2.0f);
    }

    public void spendSkillPoints(MinecraftServer server, int amount) {
        this.unspentSkillPoints -= amount;
        this.totalSpentSkillPoints += amount;
        this.sync(server);
    }

    public void spendPrestigePoints(MinecraftServer server, int amount) {
        this.unspentPrestigePoints -= amount;
        this.totalSpentPrestigePoints += amount;
        this.sync(server);
    }

    public void spendExpertisePoints(MinecraftServer server, int amount) {
        this.unspentExpertisePoints -= amount;
        this.totalSpentExpertisePoints += amount;
        this.sync(server);
    }

    public void spendKnowledgePoints(MinecraftServer server, int amount) {
        this.unspentKnowledgePoints -= amount;
        this.totalSpentKnowledgePoints += amount;
        this.sync(server);
    }

    public void spendArchetypePoints(MinecraftServer server, int amount) {
        this.unspentArchetypePoints -= amount;
        this.totalSpentArchetypePoints += amount;
        this.sync(server);
    }

    public void spendRegretPoints(MinecraftServer server, int amount) {
        this.unspentRegretPoints -= amount;
        this.totalSpentRegretPoints += amount;
        this.sync(server);
    }

    public PlayerVaultStats reset(MinecraftServer server) {
        this.vaultLevel = 0;
        this.exp = 0;
        this.unspentSkillPoints = 0;
        this.unspentKnowledgePoints = 0;
        this.unspentArchetypePoints = 0;
        this.unspentRegretPoints = 0;
        this.unspentExpertisePoints = 0;
        this.unspentPrestigePoints = 0;
        this.sync(server);
        return this;
    }

    public PlayerVaultStats resetLevel(MinecraftServer server) {
        this.vaultLevel = 0;
        this.exp = 0;
        this.sync(server);
        return this;
    }

    public PlayerVaultStats resetExpertise(MinecraftServer server) {
        this.unspentExpertisePoints = 0;
        this.totalSpentExpertisePoints = 0;
        this.sync(server);
        return this;
    }

    public PlayerVaultStats resetPrestige(MinecraftServer server) {
        this.unspentPrestigePoints = 0;
        this.totalSpentPrestigePoints = 0;
        this.sync(server);
        return this;
    }

    public PlayerVaultStats resetAbilitiesTalents(MinecraftServer server) {
        this.unspentSkillPoints = 0;
        this.totalSpentSkillPoints = 0;
        this.sync(server);
        return this;
    }

    public PlayerVaultStats resetKnowledge(MinecraftServer server) {
        this.unspentKnowledgePoints = 0;
        this.totalSpentKnowledgePoints = 0;
        this.sync(server);
        return this;
    }

    public void setTotalSpentSkillPoints(int totalSpentSkillPoints) {
        this.totalSpentSkillPoints = totalSpentSkillPoints;
    }

    public void setTotalSpentPrestigePoints(int totalSpentPrestigePoints) {
        this.totalSpentPrestigePoints = totalSpentPrestigePoints;
    }

    public void setTotalSpentExpertisePoints(int totalSpentExpertisePoints) {
        this.totalSpentExpertisePoints = totalSpentExpertisePoints;
    }

    public PlayerVaultStats setSkillPoints(int amount) {
        this.unspentSkillPoints = amount;
        this.sync(ServerLifecycleHooks.getCurrentServer());
        return this;
    }

    public PlayerVaultStats setPrestigePoints(int amount) {
        this.unspentPrestigePoints = amount;
        this.sync(ServerLifecycleHooks.getCurrentServer());
        return this;
    }

    public PlayerVaultStats setKnowledgePoints(int amount) {
        this.unspentKnowledgePoints = amount;
        this.sync(ServerLifecycleHooks.getCurrentServer());
        return this;
    }

    public PlayerVaultStats addPrestigePoints(int amount) {
        this.unspentPrestigePoints += amount;
        return this;
    }

    public PlayerVaultStats setExpertisePoints(int amount) {
        this.unspentExpertisePoints = amount;
        this.sync(ServerLifecycleHooks.getCurrentServer());
        return this;
    }

    public PlayerVaultStats addSkillPoints(int amount) {
        this.unspentSkillPoints += amount;
        return this;
    }

    public PlayerVaultStats addExpertisePoints(int amount) {
        this.unspentExpertisePoints += amount;
        return this;
    }

    public PlayerVaultStats addKnowledgePoints(int amount) {
        this.unspentKnowledgePoints += amount;
        return this;
    }

    public PlayerVaultStats addArchetypePoints(int amount) {
        this.unspentArchetypePoints += amount;
        return this;
    }

    public PlayerVaultStats resetAndReturnSkillPoints() {
        this.unspentSkillPoints += this.totalSpentSkillPoints;
        this.totalSpentSkillPoints = 0;
        return this;
    }

    public PlayerVaultStats resetAndReturnPrestigePoints() {
        this.unspentPrestigePoints += this.totalSpentPrestigePoints;
        this.totalSpentPrestigePoints = 0;
        return this;
    }

    public PlayerVaultStats resetAndReturnExpertisePoints() {
        this.unspentExpertisePoints = this.getVaultLevel() / 5;
        this.totalSpentExpertisePoints = 0;
        return this;
    }

    public PlayerVaultStats resetAndReturnKnowledgePoints() {
        this.unspentKnowledgePoints += this.totalSpentKnowledgePoints;
        this.totalSpentKnowledgePoints = 0;
        return this;
    }

    public PlayerVaultStats resetAndReturnArchetypePoints() {
        this.unspentArchetypePoints += this.totalSpentArchetypePoints;
        this.totalSpentArchetypePoints = 0;
        return this;
    }

    public PlayerVaultStats refundSkillPoints(int amount) {
        this.unspentSkillPoints += amount;
        this.totalSpentSkillPoints -= amount;
        return this;
    }

    public PlayerVaultStats refundPrestigePoints(int amount) {
        this.unspentPrestigePoints += amount;
        this.totalSpentPrestigePoints -= amount;
        return this;
    }

    public PlayerVaultStats refundKnowledgePoints(int amount) {
        this.unspentKnowledgePoints += amount;
        this.totalSpentKnowledgePoints -= amount;
        return this;
    }

    public PlayerVaultStats refundArchetypePoints(int amount) {
        this.unspentArchetypePoints += amount;
        this.totalSpentArchetypePoints -= amount;
        return this;
    }

    public void sync(MinecraftServer server) {
        NetcodeUtils.runIfPresent(server, this.uuid, player -> {
            ModNetwork.CHANNEL.sendTo((Object)new VaultLevelMessage(this.vaultLevel, this.exp, this.getExpNeededToNextLevel(), this.unspentSkillPoints, this.unspentExpertisePoints, this.unspentKnowledgePoints, this.unspentArchetypePoints, this.unspentRegretPoints, this.unspentPrestigePoints), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            EternalsData.get(server).m_77762_();
        });
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("vaultLevel", this.vaultLevel);
        nbt.m_128405_("exp", this.exp);
        nbt.m_128405_("unspentSkillPts", this.unspentSkillPoints);
        nbt.m_128405_("unspentExpertisePoints", this.unspentExpertisePoints);
        nbt.m_128405_("unspentKnowledgePts", this.unspentKnowledgePoints);
        nbt.m_128405_("unspentArchetypePoints", this.unspentArchetypePoints);
        nbt.m_128405_("unspentRegretPoints", this.unspentRegretPoints);
        nbt.m_128405_("unspentPrestigePoints", this.unspentPrestigePoints);
        nbt.m_128405_("totalSpentSkillPoints", this.totalSpentSkillPoints);
        nbt.m_128405_("totalSpentExpertisePoints", this.totalSpentExpertisePoints);
        nbt.m_128405_("totalSpentKnowledgePoints", this.totalSpentKnowledgePoints);
        nbt.m_128405_("totalSpentArchetypePoints", this.totalSpentArchetypePoints);
        nbt.m_128405_("totalSpentRegretPoints", this.totalSpentRegretPoints);
        nbt.m_128405_("totalSpentPrestigePoints", this.totalSpentPrestigePoints);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.vaultLevel = nbt.m_128451_("vaultLevel");
        this.exp = nbt.m_128451_("exp");
        this.unspentSkillPoints = nbt.m_128451_("unspentSkillPts");
        this.unspentExpertisePoints = nbt.m_128451_("unspentExpertisePoints");
        this.unspentKnowledgePoints = nbt.m_128451_("unspentKnowledgePts");
        this.unspentArchetypePoints = nbt.m_128451_("unspentArchetypePoints");
        this.unspentRegretPoints = nbt.m_128451_("unspentRegretPoints");
        this.unspentPrestigePoints = nbt.m_128451_("unspentPrestigePoints");
        this.totalSpentSkillPoints = nbt.m_128451_("totalSpentSkillPoints");
        this.totalSpentExpertisePoints = nbt.m_128451_("totalSpentExpertisePoints");
        this.totalSpentKnowledgePoints = nbt.m_128451_("totalSpentKnowledgePoints");
        this.totalSpentArchetypePoints = nbt.m_128451_("totalSpentArchetypePoints");
        this.totalSpentRegretPoints = nbt.m_128451_("totalSpentRegretPoints");
        this.totalSpentPrestigePoints = nbt.m_128451_("totalSpentPrestigePoints");
    }

    public PlayerVaultStats copy() {
        PlayerVaultStats copy = new PlayerVaultStats(this.uuid);
        copy.vaultLevel = this.vaultLevel;
        copy.exp = this.exp;
        copy.unspentSkillPoints = this.unspentSkillPoints;
        copy.unspentExpertisePoints = this.unspentExpertisePoints;
        copy.unspentKnowledgePoints = this.unspentKnowledgePoints;
        copy.unspentArchetypePoints = this.unspentArchetypePoints;
        copy.unspentRegretPoints = this.unspentRegretPoints;
        copy.unspentPrestigePoints = this.unspentPrestigePoints;
        copy.totalSpentSkillPoints = this.totalSpentSkillPoints;
        copy.totalSpentExpertisePoints = this.totalSpentExpertisePoints;
        copy.totalSpentKnowledgePoints = this.totalSpentKnowledgePoints;
        copy.totalSpentArchetypePoints = this.totalSpentArchetypePoints;
        copy.totalSpentRegretPoints = this.totalSpentRegretPoints;
        copy.totalSpentPrestigePoints = this.totalSpentPrestigePoints;
        return copy;
    }

    public PlayerVaultStats resetArchetypePoints(MinecraftServer server) {
        this.unspentArchetypePoints = 0;
        this.totalSpentArchetypePoints = 0;
        this.sync(server);
        return this;
    }
}

