/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.skillgate.ConstantSkillGate;
import iskallia.vault.config.skillgate.EitherSkillGate;
import iskallia.vault.config.skillgate.SkillGateType;
import iskallia.vault.core.data.adapter.basic.TypeSupplierAdapter;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.research.ResearchTree;
import iskallia.vault.research.type.Research;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.tree.PrestigeTree;
import iskallia.vault.skill.tree.SkillTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SkillGates {
    public static TypeSupplierAdapter<SkillGateType> GATE_TYPE = ((TypeSupplierAdapter)new TypeSupplierAdapter<SkillGateType>("type", false).register("constant", ConstantSkillGate.class, ConstantSkillGate::new)).register("either", EitherSkillGate.class, EitherSkillGate::new);
    @Expose
    private final Map<String, Entry> entries = new HashMap<String, Entry>();

    public void addEntry(String skillName, Entry entry) {
        this.entries.put(skillName, entry);
    }

    public List<String> getDependencyAbilities(String abilityName) {
        LinkedList<String> abilities = new LinkedList<String>();
        Entry entry = this.entries.get(abilityName);
        if (entry == null) {
            return abilities;
        }
        for (Skill ability : ModConfigs.ABILITIES.tree.skills) {
            if (!entry.dependsOn.stream().anyMatch(l -> l.allows(ability.getId()))) continue;
            abilities.add(ability.getId());
        }
        return abilities;
    }

    public List<String> getLockedByAbilities(String abilityName) {
        LinkedList<String> abilities = new LinkedList<String>();
        Entry entry = this.entries.get(abilityName);
        if (entry == null) {
            return abilities;
        }
        for (Skill ability : ModConfigs.ABILITIES.tree.skills) {
            if (!entry.lockedBy.stream().anyMatch(l -> l.allows(ability.getId()))) continue;
            abilities.add(ability.getId());
        }
        return abilities;
    }

    public List<String> getAbilitiesDependingOn(String abilityName) {
        LinkedList<String> abilities = new LinkedList<String>();
        Skill ability = ModConfigs.ABILITIES.getAbilityById(abilityName).orElseThrow();
        ModConfigs.ABILITIES.get().ifPresent(tree -> tree.iterate(Skill.class, skill -> {
            List<String> dependencies = ModConfigs.SKILL_GATES.getGates().getDependencyAbilities(skill.getId());
            if (dependencies.contains(ability.getId())) {
                abilities.add(skill.getId());
            }
        }));
        return abilities;
    }

    private List<String> getAllSkillIds() {
        ArrayList<String> allSkillIds = new ArrayList<String>();
        ModConfigs.TALENTS.tree.skills.forEach(s -> allSkillIds.add(s.getId()));
        ModConfigs.ABILITIES.tree.skills.forEach(s -> allSkillIds.add(s.getId()));
        ModConfigs.EXPERTISES.getAll().skills.forEach(s -> allSkillIds.add(s.getId()));
        return allSkillIds;
    }

    public List<String> getDependencySkills(String skillName) {
        LinkedList<String> skills = new LinkedList<String>();
        Entry entry = this.entries.get(skillName);
        if (entry == null) {
            return skills;
        }
        for (String skillId : this.getAllSkillIds()) {
            if (!entry.dependsOn.stream().anyMatch(l -> l.allows(skillId))) continue;
            skills.add(skillId);
        }
        return skills;
    }

    public List<String> getLockedBySkills(String skillName) {
        LinkedList<String> skills = new LinkedList<String>();
        Entry entry = this.entries.get(skillName);
        if (entry == null) {
            return skills;
        }
        for (String skillId : this.getAllSkillIds()) {
            if (!entry.lockedBy.stream().anyMatch(l -> l.allows(skillId))) continue;
            skills.add(skillId);
        }
        return skills;
    }

    public List<String> getSkillsDependingOn(String talentName, SkillTree tree) {
        LinkedList<String> talents = new LinkedList<String>();
        tree.iterate(Skill.class, skill -> {
            List<String> dependencies = ModConfigs.SKILL_GATES.getGates().getDependencySkills(skill.getId());
            if (dependencies.contains(talentName)) {
                talents.add(skill.getId());
            }
        });
        return talents;
    }

    public List<Research> getDependencyResearches(String researchName) {
        LinkedList<Research> researches = new LinkedList<Research>();
        Entry entry = this.entries.get(researchName);
        if (entry == null) {
            return researches;
        }
        for (Research research : ModConfigs.RESEARCHES.getAll()) {
            if (!entry.dependsOn.stream().anyMatch(l -> l.allows(research.getName()))) continue;
            researches.add(research);
        }
        return researches;
    }

    public List<Research> getLockedByResearches(String researchName) {
        LinkedList<Research> researches = new LinkedList<Research>();
        Entry entry = this.entries.get(researchName);
        if (entry == null) {
            return researches;
        }
        for (Research research : ModConfigs.RESEARCHES.getAll()) {
            if (!entry.lockedBy.stream().anyMatch(l -> l.allows(research.getName()))) continue;
            researches.add(research);
        }
        return researches;
    }

    public boolean isLocked(String researchName, ResearchTree researchTree) {
        SkillGates gates = ModConfigs.SKILL_GATES.getGates();
        List<String> researchesDone = researchTree.getResearchesDone();
        Entry gateEntries = gates.entries.get(researchName);
        if (gateEntries == null) {
            return false;
        }
        for (SkillGateType dependencyGate : gateEntries.dependsOn) {
            if (!researchesDone.stream().noneMatch(dependencyGate::allows)) continue;
            return true;
        }
        for (SkillGateType lockGate : gateEntries.lockedBy) {
            if (!researchesDone.stream().anyMatch(lockGate::allows)) continue;
            return true;
        }
        return false;
    }

    public boolean isLocked(String skill, SkillTree tree) {
        SkillGates gates = ModConfigs.SKILL_GATES.getGates();
        Entry gateEntries = gates.entries.get(skill);
        if (gateEntries == null) {
            return false;
        }
        List<Skill> unlockedSkills = tree.skills.stream().filter(Skill::isUnlocked).toList();
        for (SkillGateType dependencyGate : gateEntries.dependsOn) {
            if (!unlockedSkills.stream().map(Skill::getId).noneMatch(dependencyGate::allows)) continue;
            return true;
        }
        for (SkillGateType lockGate : gateEntries.lockedBy) {
            if (!unlockedSkills.stream().map(Skill::getId).anyMatch(lockGate::allows)) continue;
            return true;
        }
        return false;
    }

    public boolean hasEitherSkillGate(String researchName) {
        SkillGates gates = ModConfigs.SKILL_GATES.getGates();
        Entry gateEntries = gates.entries.get(researchName);
        if (gateEntries == null) {
            return false;
        }
        return gateEntries.dependsOn.stream().anyMatch(gateType -> gateType instanceof EitherSkillGate);
    }

    public boolean shouldDrawArrow(String entryA, String entryB) {
        Entry entry = this.entries.get(entryA);
        if (entry == null) {
            return false;
        }
        boolean depends = entry.dependsOn.stream().anyMatch(e -> e.allows(entryB));
        boolean locks = entry.lockedBy.stream().anyMatch(e -> e.allows(entryB));
        if (!depends && !locks) {
            return false;
        }
        return !entry.ignoreArrow;
    }

    public boolean isLocked(String skill, PrestigeTree tree) {
        SkillGates gates = ModConfigs.SKILL_GATES.getGates();
        Entry gateEntries = gates.entries.get(skill);
        if (gateEntries == null) {
            return false;
        }
        List<Skill> unlockedSkills = tree.skills.stream().filter(Skill::isUnlocked).toList();
        for (SkillGateType dependencyGate : gateEntries.dependsOn) {
            if (!unlockedSkills.stream().map(Skill::getId).noneMatch(dependencyGate::allows)) continue;
            return true;
        }
        for (SkillGateType lockGate : gateEntries.lockedBy) {
            if (!unlockedSkills.stream().map(Skill::getId).anyMatch(lockGate::allows)) continue;
            return true;
        }
        return false;
    }

    public static class Entry {
        @Expose
        private List<SkillGateType> dependsOn = new LinkedList<SkillGateType>();
        @Expose
        private List<SkillGateType> lockedBy = new LinkedList<SkillGateType>();
        @Expose
        private boolean ignoreArrow;

        public void setDependsOn(SkillGateType ... skills) {
            this.dependsOn.addAll(Arrays.asList(skills));
        }

        public void setLockedBy(SkillGateType ... skills) {
            this.lockedBy.addAll(Arrays.asList(skills));
        }
    }
}

