/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModParticles;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.HoldManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.calc.AbilityPowerHelper;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ArcaneAbility
extends HoldManaAbility {
    private float percentAbilityPowerDealt;
    private float range;

    public ArcaneAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCostPerSecond, float percentAbilityPowerDealt, float range) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCostPerSecond);
        this.percentAbilityPowerDealt = percentAbilityPowerDealt;
        this.range = range;
    }

    public ArcaneAbility() {
    }

    public float getPercentAbilityPowerDealt() {
        return this.percentAbilityPowerDealt;
    }

    public float getRange() {
        return this.range;
    }

    @Override
    public Ability.TickResult doActiveTick(SkillContext context) {
        Ability.TickResult res = super.doActiveTick(context);
        if (res == Ability.TickResult.COOLDOWN) {
            return res;
        }
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (!player.f_19853_.f_46443_) {
                this.fireRay((ServerPlayer)player);
            }
            return Ability.TickResult.PASS;
        }).orElse(Ability.TickResult.PASS);
    }

    private void fireRay(ServerPlayer player) {
        Vec3 start = player.m_146892_().m_82520_(0.0, -0.5, 0.0);
        Vec3 look = player.m_20154_();
        Vec3 end = start.m_82549_(look.m_82490_((double)this.range));
        Level level = player.f_19853_;
        BlockHitResult blockHit = level.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        double maxDist = this.range;
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            maxDist = blockHit.m_82450_().m_82554_(start);
            end = blockHit.m_82450_();
        }
        Predicate<Entity> predicate = e -> e instanceof LivingEntity && e != player && e.m_6087_() && e.m_6084_() && !(e instanceof PetEntity);
        EntityHitResult entityHit = ProjectileUtil.m_37304_((Level)level, (Entity)player, (Vec3)start, (Vec3)start.m_82549_(look.m_82490_(maxDist)), (AABB)player.m_142469_().m_82369_(look.m_82490_(maxDist)).m_82400_(1.0), predicate);
        Vec3 hitPos = end;
        if (entityHit != null) {
            LivingEntity target = (LivingEntity)entityHit.m_82443_();
            float damage = AbilityPowerHelper.getAbilityPower((Player)player) * this.percentAbilityPowerDealt;
            boolean isPlayer = target instanceof ServerPlayer;
            boolean allowPvP = VaultUtils.getVault(player.f_19853_).map(VaultUtils::isPvPVault).orElse(false);
            if (!isPlayer || allowPvP) {
                DamageSource source = isPlayer ? new EntityDamageSource("arcane", (Entity)player).m_19380_().m_19389_() : DamageSource.m_19344_((Player)player);
                ActiveFlags.IS_AP_ATTACKING.runIfNotSet(() -> ActiveFlags.IS_EFFECT_ATTACKING.runIfNotSet(() -> target.m_6469_(source, damage)));
            }
            hitPos = entityHit.m_82450_();
        }
        Vec3 dir = look.m_82541_();
        ServerLevel serverLevel = (ServerLevel)level;
        for (double d = 0.0; d < maxDist; d += 0.4) {
            Vec3 pos = start.m_82549_(dir.m_82490_(d));
            float offsetX = (float)(Math.random() * 0.2 - 0.1);
            float offsetZ = (float)(Math.random() * 0.2 - 0.1);
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.ARCANE.get()), pos.f_82479_ + (double)offsetX, pos.f_82480_, pos.f_82481_ + (double)offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
        float offsetX = (float)(Math.random() * 0.2 - 0.1);
        float offsetZ = (float)(Math.random() * 0.2 - 0.1);
        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.ARCANE.get()), hitPos.f_82479_ + (double)offsetX, hitPos.f_82480_, hitPos.f_82481_ + (double)offsetZ, 3, 0.0, 0.0, 0.0, 0.0);
        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11937_, SoundSource.PLAYERS, 0.5f, 2.0f);
    }

    @Override
    protected void doHoldBeginSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11937_, SoundSource.PLAYERS, 0.5f, 2.0f));
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentAbilityPowerDealt), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.range), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.percentAbilityPowerDealt = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(0.0f)).floatValue();
        this.range = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(tag -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentAbilityPowerDealt)).ifPresent(t -> tag.m_128365_("percentAbilityPowerDealt", t));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.range)).ifPresent(t -> tag.m_128365_("range", t));
            return tag;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.percentAbilityPowerDealt = Adapters.FLOAT.readNbt(nbt.m_128423_("percentAbilityPowerDealt")).orElse(Float.valueOf(0.0f)).floatValue();
        this.range = Adapters.FLOAT.readNbt(nbt.m_128423_("range")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentAbilityPowerDealt)).ifPresent(e -> json.add("percentAbilityPowerDealt", e));
            Adapters.FLOAT.writeJson(Float.valueOf(this.range)).ifPresent(e -> json.add("range", e));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.percentAbilityPowerDealt = Adapters.FLOAT.readJson(json.get("percentAbilityPowerDealt")).orElse(Float.valueOf(0.0f)).floatValue();
        this.range = Adapters.FLOAT.readJson(json.get("range")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

