/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModParticles;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.calc.AbilityPowerHelper;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ArcaneRailAbility
extends InstantManaAbility {
    private float percentAbilityPowerDealtMin;
    private float percentAbilityPowerDealtMax;

    public ArcaneRailAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float percentAbilityPowerDealtMin, float percentAbilityPowerDealtMax) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.percentAbilityPowerDealtMin = percentAbilityPowerDealtMin;
        this.percentAbilityPowerDealtMax = percentAbilityPowerDealtMax;
    }

    public ArcaneRailAbility() {
    }

    public float getPercentAbilityPowerDealtMax() {
        return this.percentAbilityPowerDealtMax;
    }

    public float getPercentAbilityPowerDealtMin() {
        return this.percentAbilityPowerDealtMin;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            this.fireBolt((ServerPlayer)player);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    private void fireBolt(ServerPlayer player) {
        Vec3 start = player.m_146892_().m_82520_(0.0, -0.5, 0.0);
        Vec3 look = player.m_20154_();
        Vec3 end = start.m_82549_(look.m_82490_(128.0));
        Level level = player.f_19853_;
        BlockHitResult blockHit = level.m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        double maxDist = 128.0;
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            maxDist = blockHit.m_82450_().m_82554_(start);
            end = blockHit.m_82450_();
        }
        Predicate<Entity> predicate = e -> e instanceof LivingEntity && e != player && e.m_6087_() && e.m_6084_() && !(e instanceof PetEntity);
        EntityHitResult entityHit = ProjectileUtil.m_37304_((Level)level, (Entity)player, (Vec3)start, (Vec3)start.m_82549_(look.m_82490_(maxDist)), (AABB)player.m_142469_().m_82369_(look.m_82490_(maxDist)).m_82400_(1.0), predicate);
        Vec3 hitPos = end;
        if (entityHit != null) {
            LivingEntity target = (LivingEntity)entityHit.m_82443_();
            float dmgPercent = player.m_21187_().nextFloat(this.percentAbilityPowerDealtMin, this.percentAbilityPowerDealtMax);
            float damage = AbilityPowerHelper.getAbilityPower((Player)player) * dmgPercent;
            boolean isPlayer = target instanceof ServerPlayer;
            boolean allowPvP = VaultUtils.getVault(player.f_19853_).map(VaultUtils::isPvPVault).orElse(false);
            if (isPlayer) {
                if (!allowPvP) {
                    return;
                }
                DamageSource source = new EntityDamageSource("arcane_rail", (Entity)player).m_19380_().m_19389_();
                ActiveFlags.IS_AP_ATTACKING.runIfNotSet(() -> ActiveFlags.IS_ARCANE_RAIL_ATTACKING.runIfNotSet(() -> target.m_6469_(source, damage)));
            } else {
                ActiveFlags.IS_AP_ATTACKING.runIfNotSet(() -> ActiveFlags.IS_ARCANE_RAIL_ATTACKING.runIfNotSet(() -> target.m_6469_(DamageSource.m_19344_((Player)player), damage)));
            }
            hitPos = entityHit.m_82450_();
        }
        Vec3 dir = look.m_82541_();
        ServerLevel serverLevel = (ServerLevel)level;
        for (double d = 0.0; d < maxDist; d += 0.3) {
            Vec3 pos = start.m_82549_(dir.m_82490_(d));
            float offsetX = player.m_21187_().nextFloat() * 0.2f - 0.1f;
            float offsetZ = player.m_21187_().nextFloat() * 0.2f - 0.1f;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.ARCANE_RAIL.get()), pos.f_82479_ + (double)offsetX, pos.f_82480_, pos.f_82481_ + (double)offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
        float offsetX = player.m_21187_().nextFloat() * 0.2f - 0.1f;
        float offsetZ = player.m_21187_().nextFloat() * 0.2f - 0.1f;
        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.ARCANE_RAIL.get()), hitPos.f_82479_ + (double)offsetX, hitPos.f_82480_, hitPos.f_82481_ + (double)offsetZ, 4, 0.0, 0.0, 0.0, 0.0);
        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11738_, SoundSource.PLAYERS, 0.5f, 2.0f);
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentAbilityPowerDealtMin), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentAbilityPowerDealtMax), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.percentAbilityPowerDealtMin = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(0.0f)).floatValue();
        this.percentAbilityPowerDealtMax = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(tag -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentAbilityPowerDealtMin)).ifPresent(t -> tag.m_128365_("percentAbilityPowerDealtMin", t));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentAbilityPowerDealtMax)).ifPresent(t -> tag.m_128365_("percentAbilityPowerDealtMax", t));
            return tag;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.percentAbilityPowerDealtMin = Adapters.FLOAT.readNbt(nbt.m_128423_("percentAbilityPowerDealtMin")).orElse(Float.valueOf(0.0f)).floatValue();
        this.percentAbilityPowerDealtMax = Adapters.FLOAT.readNbt(nbt.m_128423_("percentAbilityPowerDealtMax")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentAbilityPowerDealtMin)).ifPresent(e -> json.add("percentAbilityPowerDealtMin", e));
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentAbilityPowerDealtMax)).ifPresent(e -> json.add("percentAbilityPowerDealtMax", e));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.percentAbilityPowerDealtMin = Adapters.FLOAT.readJson(json.get("percentAbilityPowerDealtMin")).orElse(Float.valueOf(0.0f)).floatValue();
        this.percentAbilityPowerDealtMax = Adapters.FLOAT.readJson(json.get("percentAbilityPowerDealtMax")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

