/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.event.ActiveFlagsCheck;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.BonkParticleMessage;
import iskallia.vault.skill.ability.effect.spi.AbstractBonkAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.calc.AbilityPowerHelper;
import iskallia.vault.util.damage.AttackScaleHelper;
import iskallia.vault.util.damage.CritHelper;
import iskallia.vault.util.damage.ThornsReflectDamageSource;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BonkSpectralStrikeAbility
extends AbstractBonkAbility {
    private float abilityPowerPerStack;

    public BonkSpectralStrikeAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float radius, float abilityPowerPerStack, int maxStacksUsedPerHit, int maxStacksTotal, int stackDuration) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, radius, maxStacksUsedPerHit, maxStacksTotal, stackDuration);
        this.abilityPowerPerStack = abilityPowerPerStack;
    }

    public BonkSpectralStrikeAbility() {
    }

    public float getAbilityPowerPerStack() {
        return this.abilityPowerPerStack;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            List<LivingEntity> targetEntities = this.getTargetEntities(player.f_19853_, (LivingEntity)player, pos);
            int count = 0;
            for (LivingEntity livingEntity : targetEntities) {
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new BonkParticleMessage(new Vec3(livingEntity.m_20185_(), livingEntity.m_20186_() + (double)(livingEntity.m_20206_() / 2.0f), livingEntity.m_20189_()), player.m_142049_(), 38860, 5, 20 + (int)(new Random().nextFloat() * 20.0f)));
                count += EntityHelper.getEntityValue(livingEntity);
            }
            if (count > 0) {
                MobEffectInstance effectInstance;
                MobEffectInstance battleCryEffect = new MobEffectInstance(ModEffects.BATTLE_CRY_SPECTRAL_STRIKE, this.getStackDuration((LivingEntity)player), Math.min(count, this.getMaxStacksTotal()) - 1, false, false, true);
                if (player.m_21023_(ModEffects.BATTLE_CRY_SPECTRAL_STRIKE) && (effectInstance = player.m_21124_(ModEffects.BATTLE_CRY_SPECTRAL_STRIKE)) != null) {
                    battleCryEffect = new MobEffectInstance(ModEffects.BATTLE_CRY_SPECTRAL_STRIKE, this.getStackDuration((LivingEntity)player), Math.min(effectInstance.m_19564_() + 1 + count, this.getMaxStacksTotal()) - 1, false, false, true);
                }
                player.m_21195_(ModEffects.BATTLE_CRY_SPECTRAL_STRIKE);
                player.m_7292_(battleCryEffect);
            }
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doParticles(SkillContext context) {
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            player.f_19853_.m_6263_((Player)player, pos.f_82479_, pos.f_82480_, pos.f_82481_, ModSounds.BONK_CHARGE, SoundSource.PLAYERS, 1.0f, 0.7f);
            player.m_6330_(ModSounds.BONK_CHARGE, SoundSource.PLAYERS, 1.0f, 0.7f);
        });
    }

    @SubscribeEvent
    public static void on(LivingHurtEvent event) {
        if (ActiveFlagsCheck.isAnyFlagActiveLuckyHit()) {
            return;
        }
        if (event.getSource() instanceof ThornsReflectDamageSource) {
            return;
        }
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer attacker = (ServerPlayer)source;
        if (!attacker.m_21023_(ModEffects.BATTLE_CRY_SPECTRAL_STRIKE)) {
            return;
        }
        if (CritHelper.getCrit((Player)attacker)) {
            return;
        }
        if (AttackScaleHelper.getLastAttackScale((Player)attacker) < 1.0f) {
            return;
        }
        MobEffectInstance battleCry = attacker.m_21124_(ModEffects.BATTLE_CRY_SPECTRAL_STRIKE);
        if (battleCry == null) {
            return;
        }
        AbilityTree abilities = PlayerAbilitiesData.get((ServerLevel)attacker.f_19853_).getAbilities((Player)attacker);
        for (BonkSpectralStrikeAbility ability : abilities.getAll(BonkSpectralStrikeAbility.class, Skill::isUnlocked)) {
            int stacksUsed = ability.getMaxStacksUsedPerHit();
            MobEffectInstance newBattleCry = null;
            if (battleCry.m_19564_() - stacksUsed >= 0) {
                newBattleCry = new MobEffectInstance(battleCry.m_19544_(), battleCry.m_19557_(), battleCry.m_19564_() - stacksUsed, false, false, true);
            } else {
                stacksUsed = battleCry.m_19564_() + 1;
            }
            float damage = event.getAmount();
            event.setAmount(damage + AbilityPowerHelper.getAbilityPower((Player)attacker) * (ability.getAbilityPowerPerStack() * (float)stacksUsed));
            attacker.f_19853_.m_6263_((Player)attacker, attacker.m_20182_().f_82479_, attacker.m_20182_().f_82480_, attacker.m_20182_().f_82481_, ModSounds.BONK, SoundSource.PLAYERS, 1.0f, 0.7f);
            attacker.m_6330_(ModSounds.BONK, SoundSource.PLAYERS, 1.0f, 0.7f);
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new BonkParticleMessage(new Vec3(attacker.m_20185_(), attacker.m_20186_() + (double)(attacker.m_20206_() / 3.0f), attacker.m_20189_()), event.getEntity().m_142049_(), 38860, 5 * stacksUsed, 5 + (int)(new Random().nextFloat() * 10.0f)));
            attacker.m_21195_(ModEffects.BATTLE_CRY_SPECTRAL_STRIKE);
            if (newBattleCry == null) continue;
            attacker.m_7292_(newBattleCry);
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.abilityPowerPerStack), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.abilityPowerPerStack = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.abilityPowerPerStack)).ifPresent(tag -> nbt.m_128365_("abilityPowerPerStack", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.abilityPowerPerStack = Adapters.FLOAT.readNbt(nbt.m_128423_("abilityPowerPerStack")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.abilityPowerPerStack)).ifPresent(element -> json.add("abilityPowerPerStack", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.abilityPowerPerStack = Adapters.FLOAT.readJson(json.get("abilityPowerPerStack")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

