/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.StunnedParticleMessage;
import iskallia.vault.skill.ability.effect.spi.AbstractChainLightningAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.talent.type.LightningDamageTalent;
import iskallia.vault.skill.talent.type.LightningStunTalent;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.calc.AbilityPowerHelper;
import iskallia.vault.world.data.PlayerTalentsData;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ArrowRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class ChainLightningAbility
extends AbstractChainLightningAbility {
    public ChainLightningAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float percentAbilityPowerDealtMin, float percentAbilityPowerDealtMax, float throwPower, float distance, float chainRange) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, percentAbilityPowerDealtMin, percentAbilityPowerDealtMax, throwPower, distance, chainRange);
    }

    public ChainLightningAbility() {
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            ChainLightningProjectile proj = new ChainLightningProjectile(player.f_19853_, (LivingEntity)player, this);
            proj.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.getThrowPower(), 0.0f);
            player.f_19853_.m_7967_((Entity)proj);
            player.f_19853_.m_6269_(null, (Entity)player, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt();
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson();
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
    }

    public static class ChainLightningProjectile
    extends AbstractArrow {
        private static final EntityDataAccessor<Float> DAMAGE_MIN = SynchedEntityData.m_135353_(ChainLightningProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        private static final EntityDataAccessor<Float> DAMAGE_MAX = SynchedEntityData.m_135353_(ChainLightningProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        private static final EntityDataAccessor<Float> CHAIN_RANGE = SynchedEntityData.m_135353_(ChainLightningProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        private static final EntityDataAccessor<Float> DISTANCE = SynchedEntityData.m_135353_(ChainLightningProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(ChainLightningProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        private static final EntityDataAccessor<Optional<UUID>> SHOOTER_UUID = SynchedEntityData.m_135353_(ChainLightningProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
        private static final EntityDataAccessor<Float> START_X = SynchedEntityData.m_135353_(ChainLightningProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        private static final EntityDataAccessor<Float> START_Y = SynchedEntityData.m_135353_(ChainLightningProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        private static final EntityDataAccessor<Float> START_Z = SynchedEntityData.m_135353_(ChainLightningProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        private Player cachedShooter;

        public ChainLightningProjectile(EntityType<? extends AbstractArrow> type, Level level) {
            super(type, level);
            this.m_20242_(true);
            this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        }

        public ChainLightningProjectile(Level level, LivingEntity shooter, AbstractChainLightningAbility ability) {
            super(ModEntities.CHAIN_LIGHTNING_PROJECTILE, shooter, level);
            Vec3 look = shooter.m_20154_();
            Vec3 start = shooter.m_146892_().m_82549_(look);
            this.m_146884_(start);
            this.m_20242_(true);
            this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            if (shooter instanceof Player) {
                Player player = (Player)shooter;
                this.f_19804_.m_135381_(SHOOTER_UUID, Optional.of(player.m_142081_()));
                this.cachedShooter = player;
            }
            this.f_19804_.m_135381_(START_X, (Object)Float.valueOf((float)start.f_82479_));
            this.f_19804_.m_135381_(START_Y, (Object)Float.valueOf((float)start.f_82480_));
            this.f_19804_.m_135381_(START_Z, (Object)Float.valueOf((float)start.f_82481_));
            this.f_19804_.m_135381_(DAMAGE_MIN, (Object)Float.valueOf(ability.getRandomDamagePercent((ServerPlayer)shooter)));
            this.f_19804_.m_135381_(DAMAGE_MAX, (Object)Float.valueOf(ability.getRandomDamagePercent((ServerPlayer)shooter)));
            this.f_19804_.m_135381_(CHAIN_RANGE, (Object)Float.valueOf(ability.getChainRange()));
            this.f_19804_.m_135381_(DISTANCE, (Object)Float.valueOf(ability.getDistance()));
            this.f_19804_.m_135381_(AGE, (Object)0);
        }

        protected void m_8097_() {
            super.m_8097_();
            this.f_19804_.m_135372_(DAMAGE_MIN, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135372_(DAMAGE_MAX, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135372_(CHAIN_RANGE, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135372_(DISTANCE, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135372_(AGE, (Object)0);
            this.f_19804_.m_135372_(SHOOTER_UUID, Optional.empty());
            this.f_19804_.m_135372_(START_X, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135372_(START_Y, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135372_(START_Z, (Object)Float.valueOf(0.0f));
        }

        @Nullable
        private Player getShooter() {
            if (this.cachedShooter != null && !this.cachedShooter.m_146910_()) {
                return this.cachedShooter;
            }
            this.cachedShooter = ((Optional)this.f_19804_.m_135370_(SHOOTER_UUID)).map(value -> this.f_19853_.m_46003_(value)).orElse(null);
            return this.cachedShooter;
        }

        protected void m_6532_(@Nullable HitResult result) {
            EntityHitResult ehr;
            Entity entity;
            this.doChainDamage(result);
            this.m_146870_();
            if (result instanceof EntityHitResult && (entity = (ehr = (EntityHitResult)result).m_82443_()) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.f_19853_.m_6269_(null, (Entity)living, ModSounds.LIGHTING_BOLT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }

        private void doChainDamage(@Nullable HitResult result) {
            EntityHitResult ehr;
            Entity entity;
            Player player = this.getShooter();
            if (player == null) {
                return;
            }
            LivingEntity hit = null;
            if (result instanceof EntityHitResult && (entity = (ehr = (EntityHitResult)result).m_82443_()) instanceof LivingEntity) {
                LivingEntity living;
                hit = living = (LivingEntity)entity;
            }
            if (hit != null) {
                float abilityPower = AbilityPowerHelper.getAbilityPower(player);
                float damage = abilityPower * this.getModifiedLightningDamage(player, Mth.m_14068_((Random)player.m_21187_(), (float)((Float)this.f_19804_.m_135370_(DAMAGE_MIN)).floatValue(), (float)((Float)this.f_19804_.m_135370_(DAMAGE_MAX)).floatValue()));
                if (hit != player) {
                    this.applyLightningDamage(hit, damage, player);
                }
                ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
                EntityHelper.getEntitiesInRange((LevelAccessor)player.f_19853_, hit.m_20182_(), ((Float)this.f_19804_.m_135370_(CHAIN_RANGE)).floatValue(), e -> e instanceof LivingEntity && e != player, targets);
                targets.remove(hit);
                targets.remove(player);
                for (LivingEntity other : targets) {
                    this.applyLightningDamage(other, damage, player);
                }
            }
        }

        private float getModifiedLightningDamage(Player player, float baseDamage) {
            float additional = 0.0f;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                TalentTree talents = PlayerTalentsData.get(serverPlayer.m_183503_()).getTalents(player);
                for (LightningDamageTalent talent : talents.getAll(LightningDamageTalent.class, Skill::isUnlocked)) {
                    additional += talent.getIncreasedDamageDealtPercentage();
                }
            }
            return baseDamage * (1.0f + additional);
        }

        private void applyLightningDamage(LivingEntity target, float damage, Player player) {
            ActiveFlags.IS_AP_ATTACKING.runIfNotSet(() -> ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> target.m_6469_(DamageSource.m_19344_((Player)player), damage)));
            Entity bolt = ModEntities.SMITE_ABILITY_BOLT.m_20615_(target.f_19853_);
            if (bolt != null) {
                bolt.m_20219_(target.m_20182_());
                target.f_19853_.m_7967_(bolt);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                TalentTree talents = PlayerTalentsData.get(serverPlayer.m_183503_()).getTalents(player);
                for (LightningStunTalent talent : talents.getAll(LightningStunTalent.class, Skill::isUnlocked)) {
                    if (!(player.f_19853_.f_46441_.nextFloat() < talent.getStunChance())) continue;
                    target.m_7292_(new MobEffectInstance(ModEffects.NO_AI, (int)(talent.getStunDuration() * 20.0f), 0, false, false, true){

                        public boolean m_19552_(LivingEntity livingEntity, Runnable p_19554_) {
                            if (!livingEntity.m_21224_()) {
                                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StunnedParticleMessage(new Vec3(livingEntity.m_20185_(), livingEntity.m_20186_() + (double)livingEntity.m_20206_(), livingEntity.m_20189_()), livingEntity.m_20205_()));
                            }
                            return super.m_19552_(livingEntity, p_19554_);
                        }
                    });
                }
            }
        }

        public void m_8119_() {
            Player shooter = this.getShooter();
            if (shooter == null || !shooter.m_6084_()) {
                this.m_146870_();
                return;
            }
            if (!this.f_19853_.f_46443_) {
                int currentAge = (Integer)this.f_19804_.m_135370_(AGE);
                this.f_19804_.m_135381_(AGE, (Object)(currentAge + 1));
                if (currentAge > 400) {
                    this.m_146870_();
                    return;
                }
            }
            int age = (Integer)this.f_19804_.m_135370_(AGE);
            Vec3 origin = new Vec3((double)((Float)this.f_19804_.m_135370_(START_X)).floatValue(), (double)((Float)this.f_19804_.m_135370_(START_Y)).floatValue(), (double)((Float)this.f_19804_.m_135370_(START_Z)).floatValue());
            if (age > 2 && origin.m_82554_(this.m_20182_()) > (double)((Float)this.f_19804_.m_135370_(DISTANCE)).floatValue()) {
                this.m_146870_();
                return;
            }
            super.m_8119_();
        }

        protected ItemStack m_7941_() {
            return ItemStack.f_41583_;
        }

        public Packet<?> m_5654_() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LightningArrowRenderer
    extends ArrowRenderer<ChainLightningProjectile> {
        private static final ResourceLocation TEXTURE = VaultMod.id("textures/entity/warp_arrow.png");

        public LightningArrowRenderer(EntityRendererProvider.Context context) {
            super(context);
        }

        @Nonnull
        public ResourceLocation getTextureLocation(@Nonnull ChainLightningProjectile entity) {
            return TEXTURE;
        }

        public void render(ChainLightningProjectile entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
            super.m_7392_((AbstractArrow)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
            double x = Mth.m_14139_((double)partialTicks, (double)entity.f_19790_, (double)entity.m_20185_());
            double y = Mth.m_14139_((double)partialTicks, (double)entity.f_19791_, (double)entity.m_20186_());
            double z = Mth.m_14139_((double)partialTicks, (double)entity.f_19792_, (double)entity.m_20189_());
            entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

