/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.easteregg.GrasshopperNinja;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.MathUtilities;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class DashAbility
extends InstantManaAbility {
    private int extraDistance;

    public DashAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int extraDistance) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.extraDistance = extraDistance;
    }

    public DashAbility() {
    }

    public int getExtraDistance() {
        return this.extraDistance;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(Player.class).map(player -> {
            Vec3 lookVector = player.m_20154_();
            float magnitude = (float)(10 + this.extraDistance) * 0.15f;
            double extraPitch = 10.0;
            Vec3 dashVector = new Vec3(lookVector.m_7096_(), lookVector.m_7098_(), lookVector.m_7094_());
            float initialYaw = (float)MathUtilities.extractYaw(dashVector);
            double dashPitch = Math.toDegrees(MathUtilities.extractPitch(dashVector = MathUtilities.rotateYaw(dashVector, initialYaw)));
            if (dashPitch + extraPitch > 90.0) {
                dashVector = new Vec3(0.0, 1.0, 0.0);
                dashPitch = 90.0;
            } else {
                dashVector = MathUtilities.rotateRoll(dashVector, (float)Math.toRadians(-extraPitch));
                dashVector = MathUtilities.rotateYaw(dashVector, -initialYaw);
                dashVector = dashVector.m_82541_();
            }
            double coeff = 1.6 - MathUtilities.map(Math.abs(dashPitch), 0.0, 90.0, 0.6, 1.0);
            dashVector = dashVector.m_82490_((double)magnitude * coeff);
            player.m_5997_(dashVector.m_7096_(), dashVector.m_7098_(), dashVector.m_7094_());
            player.f_19864_ = true;
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doParticles(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123759_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 50, 1.0, 0.5, 1.0, 0.0));
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            if (GrasshopperNinja.isGrasshopperShape((Player)player)) {
                player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.GRASSHOPPER_BRRR, SoundSource.PLAYERS, 0.2f, 1.0f);
                player.m_6330_(ModSounds.GRASSHOPPER_BRRR, SoundSource.PLAYERS, 0.2f, 1.0f);
                GrasshopperNinja.achieve(player);
            } else {
                player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.DASH_SFX, SoundSource.PLAYERS, 0.2f, 1.0f);
                player.m_6330_(ModSounds.DASH_SFX, SoundSource.PLAYERS, 0.2f, 1.0f);
            }
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.extraDistance, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.extraDistance = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.extraDistance).ifPresent(tag -> nbt.m_128365_("extraDistance", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.extraDistance = Adapters.INT.readNbt(nbt.m_128423_("extraDistance")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.extraDistance).ifPresent(element -> json.add("extraDistance", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.extraDistance = Adapters.INT.readJson(json.get("extraDistance")).orElse(0);
    }
}

