/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.ability.effect.DashAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.AABBHelper;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.util.damage.PlayerDamageHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class DashDamageAbility
extends DashAbility {
    private static final float DAMAGE_RANGE = 2.0f;
    private static final int DAMAGE_DURATION_TICKS = 20;
    private float attackDamagePercentPerDash;
    private PlayerDashDamageData data;

    private static TargetingConditions makeTargetingConditions(ServerPlayer player, float range) {
        boolean allowPlayers = VaultUtils.getVault(player.f_19853_).map(VaultUtils::isPvPVault).orElse(false);
        return TargetingConditions.m_148352_().m_26883_((double)range).m_26888_(entity -> allowPlayers || !(entity instanceof Player));
    }

    public DashDamageAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int extraDistance, float attackDamagePercentPerDash) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, extraDistance);
        this.attackDamagePercentPerDash = attackDamagePercentPerDash;
        this.data = null;
    }

    public DashDamageAbility() {
    }

    public float getAttackDamagePercentPerDash() {
        return this.attackDamagePercentPerDash;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            super.doAction(context);
            this.data = new PlayerDashDamageData(20);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    public void onTick(SkillContext context) {
        super.onTick(context);
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            if (this.data == null) {
                return;
            }
            float range = 2.0f;
            range = AreaOfEffectHelper.adjustAreaOfEffect((LivingEntity)player, this, range);
            TargetingConditions conditions = DashDamageAbility.makeTargetingConditions(player, range);
            List nearbyEntities = player.f_19853_.m_45971_(LivingEntity.class, conditions, (LivingEntity)player, AABBHelper.create(player.m_20182_(), range));
            for (LivingEntity nearbyEntity : nearbyEntities) {
                UUID nearbyEntityUUID = nearbyEntity.m_142081_();
                if (this.data.hitEntityIdSet.contains(nearbyEntityUUID)) continue;
                float baseAttackDamage = (float)player.m_21133_(Attributes.f_22281_);
                float attackDamagePercentageIncrease = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player).getAttributeValue(ModGearAttributes.DAMAGE_INCREASE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
                float increase = baseAttackDamage * attackDamagePercentageIncrease;
                float playerDashDamage = (baseAttackDamage += increase) * this.getAttackDamagePercentPerDash();
                float finalPlayerDashDamage = playerDashDamage *= PlayerDamageHelper.getDamageMultiplier((Player)player, true, false);
                ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> nearbyEntity.m_6469_(DamageSource.m_19344_((Player)player), finalPlayerDashDamage));
                this.data.hitEntityIdSet.add(nearbyEntityUUID);
            }
            --this.data.durationTicks;
            if (this.data.durationTicks <= 0) {
                this.data = null;
            }
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.attackDamagePercentPerDash), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.attackDamagePercentPerDash = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.attackDamagePercentPerDash)).ifPresent(tag -> nbt.m_128365_("attackDamagePercentPerDash", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.attackDamagePercentPerDash = Adapters.FLOAT.readNbt(nbt.m_128423_("attackDamagePercentPerDash")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.attackDamagePercentPerDash)).ifPresent(element -> json.add("attackDamagePercentPerDash", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.attackDamagePercentPerDash = Adapters.FLOAT.readJson(json.get("attackDamagePercentPerDash")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    private static class PlayerDashDamageData {
        private final Set<UUID> hitEntityIdSet = new HashSet<UUID>();
        private int durationTicks;

        private PlayerDashDamageData(int durationTicks) {
            this.durationTicks = durationTicks;
        }
    }
}

