/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import iskallia.vault.VaultMod;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.etching.EtchingGearAttributes;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEntities;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantAbility;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TieredSkill;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ArrowRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;

public class DashWarpAbility
extends InstantManaAbility {
    private float projectileLaunchForce;

    public DashWarpAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float projectileLaunchForce) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.projectileLaunchForce = projectileLaunchForce;
    }

    public DashWarpAbility() {
    }

    public float getProjectileLaunchForce() {
        return this.projectileLaunchForce;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(this::doAction).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doParticles(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(this::doParticles);
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(this::doSound);
    }

    private Ability.ActionResult doAction(ServerPlayer player) {
        WarpArrow warpArrow = new WarpArrow(player.f_19853_, player);
        warpArrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.getProjectileLaunchForce(), 1.0f);
        warpArrow.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        player.f_19853_.m_7967_((Entity)warpArrow);
        return Ability.ActionResult.successCooldownImmediate();
    }

    private void doParticles(ServerPlayer serverPlayer) {
    }

    private void doSound(ServerPlayer player) {
        player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12520_, SoundSource.PLAYERS, 0.5f, 2.0f);
        player.m_6330_(SoundEvents.f_12520_, SoundSource.PLAYERS, 0.5f, 2.0f);
    }

    private static void castLandingNova(ServerPlayer player) {
        EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.DASH_WARP_NOVA).stream().findFirst().ifPresent(stack -> {
            String abilityId = (String)((Pair)stack.getValue()).getFirst();
            int level = (Integer)((Pair)stack.getValue()).getSecond();
            ModConfigs.ABILITIES.getAbilityById(abilityId).filter(s -> s instanceof TieredSkill).map(s -> (TieredSkill)s).ifPresent(tiered -> {
                int idx = Mth.m_14045_((int)level, (int)1, (int)tiered.getTiers().size());
                LearnableSkill child = tiered.getChild(idx);
                if (child instanceof InstantAbility) {
                    InstantAbility ability = (InstantAbility)child;
                    ability.onAction(SkillContext.of(player));
                } else {
                    VaultMod.LOGGER.error("DashWarpNovaEtching ability {} level {} is not InstantAbility", (Object)abilityId, (Object)idx);
                }
            });
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.projectileLaunchForce), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.projectileLaunchForce = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.projectileLaunchForce)).ifPresent(tag -> nbt.m_128365_("projectileLaunchForce", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.projectileLaunchForce = Adapters.FLOAT.readNbt(nbt.m_128423_("projectileLaunchForce")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.projectileLaunchForce)).ifPresent(element -> json.add("projectileLaunchForce", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.projectileLaunchForce = Adapters.FLOAT.readJson(json.get("projectileLaunchForce")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static class WarpArrow
    extends AbstractArrow {
        private static final EntityDataAccessor<Optional<UUID>> PLAYER_UUID = SynchedEntityData.m_135353_(WarpArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
        private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(WarpArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        private Player cachedPlayer;

        public WarpArrow(EntityType<? extends AbstractArrow> entityType, Level level) {
            super(entityType, level);
        }

        public WarpArrow(Level level, ServerPlayer serverPlayer) {
            super(ModEntities.WARP_ARROW, (LivingEntity)serverPlayer, level);
            this.f_19804_.m_135381_(PLAYER_UUID, Optional.of(serverPlayer.m_142081_()));
            this.f_19804_.m_135381_(AGE, (Object)0);
            this.cachedPlayer = serverPlayer;
        }

        protected void m_8097_() {
            super.m_8097_();
            this.f_19804_.m_135372_(PLAYER_UUID, Optional.empty());
            this.f_19804_.m_135372_(AGE, (Object)0);
        }

        @Nullable
        private Player getPlayer() {
            if (this.cachedPlayer != null && !this.cachedPlayer.m_146910_()) {
                return this.cachedPlayer;
            }
            this.cachedPlayer = ((Optional)this.f_19804_.m_135370_(PLAYER_UUID)).map(value -> this.f_19853_.m_46003_(value)).orElse(null);
            return this.cachedPlayer;
        }

        protected boolean m_142470_(@Nonnull Player player) {
            return false;
        }

        @Nonnull
        protected ItemStack m_7941_() {
            return ItemStack.f_41583_;
        }

        public void m_8119_() {
            Player player = this.getPlayer();
            if (player == null || !player.m_6084_()) {
                this.m_146870_();
            }
            if (player != null && !player.f_19853_.f_46443_) {
                int currentAge = (Integer)this.m_20088_().m_135370_(AGE);
                this.m_20088_().m_135381_(AGE, (Object)(currentAge + 1));
                if (currentAge > 400) {
                    this.m_146870_();
                }
            }
            super.m_8119_();
        }

        @ParametersAreNonnullByDefault
        @Nullable
        public Entity changeDimension(ServerLevel serverLevel, ITeleporter teleporter) {
            Player player = this.getPlayer();
            if (player != null && player.f_19853_.m_46472_() != serverLevel.m_46472_()) {
                this.m_146870_();
            }
            return null;
        }

        protected void m_6532_(HitResult hitResult) {
            HitResult.Type hitResultType = hitResult.m_6662_();
            if (hitResultType == HitResult.Type.BLOCK) {
                this.m_8060_((BlockHitResult)hitResult);
            } else if (hitResultType == HitResult.Type.ENTITY) {
                this.m_5790_((EntityHitResult)hitResult);
            } else if (hitResultType == HitResult.Type.MISS) {
                this.m_146870_();
            }
        }

        protected void m_8060_(@Nonnull BlockHitResult blockHitResult) {
            ServerPlayer serverPlayer;
            ServerLevel serverLevel;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            Level level = this.f_19853_;
                            if (!(level instanceof ServerLevel)) break block4;
                            serverLevel = (ServerLevel)level;
                            if (!this.m_146910_()) break block5;
                        }
                        return;
                    }
                    Player player = this.getPlayer();
                    if (!(player instanceof ServerPlayer)) break block6;
                    serverPlayer = (ServerPlayer)player;
                    if (serverPlayer.f_8906_.m_6198_().m_129536_() && serverPlayer.f_19853_ == this.f_19853_ && !serverPlayer.m_5803_()) break block7;
                }
                this.m_146870_();
                return;
            }
            Vec3 origin = serverPlayer.m_20182_();
            this.getTeleportPosition(serverLevel, origin, this.m_20182_()).ifPresent(target -> {
                this.teleport((Entity)serverPlayer, (Vec3)target);
                this.playTeleportSound(serverLevel, serverPlayer, (Vec3)target);
                this.sendTeleportParticles(serverLevel, origin);
                DashWarpAbility.castLandingNova(serverPlayer);
            });
            this.m_146870_();
        }

        protected void m_5790_(@Nonnull EntityHitResult entityHitResult) {
            ServerPlayer serverPlayer;
            ServerLevel serverLevel;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            Level level = this.f_19853_;
                            if (!(level instanceof ServerLevel)) break block8;
                            serverLevel = (ServerLevel)level;
                            if (!this.m_146910_()) break block9;
                        }
                        return;
                    }
                    Player player = this.getPlayer();
                    if (!(player instanceof ServerPlayer)) break block10;
                    serverPlayer = (ServerPlayer)player;
                    if (serverPlayer.f_8906_.m_6198_().m_129536_() && serverPlayer.f_19853_ == this.f_19853_ && !serverPlayer.m_5803_()) break block11;
                }
                this.m_146870_();
                return;
            }
            Entity entity = entityHitResult.m_82443_();
            Vec3 origin = serverPlayer.m_20182_();
            Vec3 target = entity.m_20182_();
            Optional<Vec3> playerTarget = this.getTeleportPosition(serverLevel, origin, target);
            Optional<Vec3> entityTarget = this.getTeleportPosition(serverLevel, target, origin);
            if (playerTarget.isPresent() && entityTarget.isPresent()) {
                this.teleport((Entity)serverPlayer, playerTarget.get());
                this.playTeleportSound(serverLevel, serverPlayer, playerTarget.get());
                this.sendTeleportParticles(serverLevel, origin);
                DashWarpAbility.castLandingNova(serverPlayer);
                if (this.canEntityBeTeleported(entity)) {
                    this.teleport(entity, entityTarget.get());
                    this.playTeleportSound(serverLevel, serverPlayer, entityTarget.get());
                }
                this.sendTeleportParticles(serverLevel, target);
            }
            this.m_146870_();
        }

        private boolean canEntityBeTeleported(Entity target) {
            return target.m_6084_() && target instanceof LivingEntity;
        }

        private void teleport(Entity entity, Vec3 target) {
            if (entity.m_20159_()) {
                entity.m_142098_(target.f_82479_, target.f_82480_, target.f_82481_);
            } else {
                entity.m_6021_(target.f_82479_, target.f_82480_, target.f_82481_);
            }
            entity.m_183634_();
        }

        private void sendTeleportParticles(ServerLevel serverLevel, Vec3 origin) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123789_, origin.m_7096_(), origin.m_7098_() + 1.0, origin.m_7094_(), 100, 0.25, 0.5, 0.25, 0.0);
        }

        private void playTeleportSound(ServerLevel serverLevel, ServerPlayer player, Vec3 target) {
            serverLevel.m_6263_((Player)player, target.m_7096_(), target.m_7098_(), target.m_7094_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 0.5f, 2.0f);
            player.m_6330_(SoundEvents.f_11852_, SoundSource.PLAYERS, 0.5f, 2.0f);
        }

        private Optional<Vec3> getTeleportPosition(ServerLevel serverLevel, Vec3 origin, Vec3 target) {
            BlockPos targetBlockPos = new BlockPos(target);
            BlockPos originBlockPos = new BlockPos(origin);
            if (targetBlockPos.equals((Object)originBlockPos)) {
                return Optional.empty();
            }
            List<Object> candidatePositions = new ArrayList<BlockPos>();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        candidatePositions.add(targetBlockPos.m_142082_(x, y, z));
                    }
                }
            }
            Predicate<BlockPos> filter = bp -> this.isPassable(serverLevel.m_8055_(bp)) && this.isPassable(serverLevel.m_8055_(bp.m_7494_()));
            Comparator<BlockPos> comparator = Comparator.comparingDouble(value -> value.m_123331_((Vec3i)targetBlockPos));
            comparator = comparator.thenComparingDouble(value -> value.m_203193_((Position)origin));
            if ((candidatePositions = candidatePositions.stream().filter(filter).sorted(comparator).toList()).isEmpty()) {
                return Optional.empty();
            }
            BlockPos result = (BlockPos)candidatePositions.get(0);
            if (result.equals((Object)originBlockPos)) {
                return Optional.empty();
            }
            return Optional.of(new Vec3((double)result.m_123341_() + 0.5, (double)result.m_123342_(), (double)result.m_123343_() + 0.5));
        }

        private boolean isPassable(BlockState blockState) {
            if (blockState.m_60795_()) {
                return true;
            }
            return !blockState.m_60819_().m_76178_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WarpArrowRenderer
    extends ArrowRenderer<WarpArrow> {
        public static final ResourceLocation TEXTURE_LOCATION = VaultMod.id("textures/entity/warp_arrow.png");

        public WarpArrowRenderer(EntityRendererProvider.Context context) {
            super(context);
        }

        @Nonnull
        public ResourceLocation getTextureLocation(@Nonnull WarpArrow entity) {
            return TEXTURE_LOCATION;
        }

        @ParametersAreNonnullByDefault
        public void render(WarpArrow entity, float pEntityYaw, float partialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
            super.m_7392_((AbstractArrow)entity, pEntityYaw, partialTicks, pMatrixStack, pBuffer, pPackedLight);
            int age = (Integer)entity.m_20088_().m_135370_(WarpArrow.AGE);
            if (age < 2) {
                return;
            }
            double x = Mth.m_14139_((double)partialTicks, (double)entity.f_19790_, (double)entity.m_20185_());
            double y = Mth.m_14139_((double)partialTicks, (double)entity.f_19791_, (double)entity.m_20186_());
            double z = Mth.m_14139_((double)partialTicks, (double)entity.f_19792_, (double)entity.m_20189_());
            entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123789_, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

