/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.skill.ability.effect.spi.AbstractEarthquakeAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.ServerScheduler;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class EarthquakeAbility
extends AbstractEarthquakeAbility {
    private int delayTicks;

    public EarthquakeAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float radius, float percentAttackDamageDealt, float knockbackStrengthMultiplier, int delayTicks, float blockDestructionChance, float blockReplacementChance) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, radius, percentAttackDamageDealt, knockbackStrengthMultiplier, blockDestructionChance, blockReplacementChance);
        this.delayTicks = delayTicks;
    }

    public EarthquakeAbility() {
    }

    public int getDelayTicks() {
        return this.delayTicks;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            Level patt2307$temp = player.f_19853_;
            if (patt2307$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt2307$temp;
                float radius = this.getRadius((Entity)player);
                this.showPreviewParticles(serverLevel, pos, radius);
                int particleSteps = Math.min(20, this.delayTicks / 2);
                for (int i = 1; i <= particleSteps; ++i) {
                    float intensity = (float)i / (float)particleSteps;
                    int tickDelay = this.delayTicks * i / particleSteps;
                    float finalIntensity = intensity;
                    ServerScheduler.INSTANCE.schedule(tickDelay, () -> this.showBuildupParticles(serverLevel, pos, radius, finalIntensity));
                }
            }
            Vec3 finalPos = pos;
            ServerScheduler.INSTANCE.schedule(this.delayTicks, () -> this.triggerExplosion((ServerPlayer)player, finalPos, true));
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    private void showPreviewParticles(ServerLevel level, Vec3 pos, float radius) {
        int particlesPerCircle = Math.min(60, (int)(radius * 8.0f));
        float step = (float)(Math.PI * 2 / (double)particlesPerCircle);
        for (int i = 0; i < particlesPerCircle; ++i) {
            float angle = (float)i * step;
            double x = pos.f_82479_ + (double)radius * Math.cos(angle);
            double z = pos.f_82481_ + (double)radius * Math.sin(angle);
            level.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.8f, 0.6f, 0.3f), 1.0f), x, pos.f_82480_ + 0.1, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        int radiusInt = Math.max(1, (int)Math.ceil(radius));
        BlockPos center = new BlockPos(pos);
        for (int x = -radiusInt; x <= radiusInt; ++x) {
            for (int z = -radiusInt; z <= radiusInt; ++z) {
                BlockState state;
                BlockPos blockPos = center.m_142082_(x, 0, z);
                double distance = Math.sqrt(blockPos.m_123331_((Vec3i)center));
                if (!(distance <= (double)radius) || (state = level.m_8055_(blockPos)).m_60795_()) continue;
                level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.1, (double)blockPos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void showBuildupParticles(ServerLevel level, Vec3 pos, float radius, float intensity) {
        int particleCount = (int)(radius * radius * 3.0f * intensity);
        float maxOffset = 0.4f * intensity;
        List entities = level.m_45976_(LivingEntity.class, this.createEffectAABB(pos, radius));
        boolean allowPlayers = VaultUtils.getVault((Level)level).map(VaultUtils::isPvPVault).orElse(false);
        for (LivingEntity entity : entities) {
            if (!allowPlayers && entity instanceof Player || !(level.f_46441_.nextFloat() < 0.3f * intensity)) continue;
            double offsetX = (level.f_46441_.nextDouble() - 0.5) * (double)maxOffset;
            double offsetZ = (level.f_46441_.nextDouble() - 0.5) * (double)maxOffset;
            entity.m_5997_(offsetX, 0.35 * (double)intensity, offsetZ);
        }
        for (int i = 0; i < particleCount; ++i) {
            BlockState blockState;
            double distance = level.f_46441_.nextDouble() * (double)radius;
            double angle = level.f_46441_.nextDouble() * 2.0 * Math.PI;
            double x = pos.f_82479_ + distance * Math.cos(angle);
            double z = pos.f_82481_ + distance * Math.sin(angle);
            BlockPos blockPos = new BlockPos(x, pos.f_82480_ - 1.0, z);
            while (blockPos.m_123342_() > level.m_141937_() && (level.m_46859_(blockPos) || level.m_45752_(level.m_8055_(blockPos), blockPos, CollisionContext.m_82749_()))) {
                blockPos = blockPos.m_7495_();
            }
            if (blockPos.m_123342_() <= level.m_141937_() || (blockState = level.m_8055_(blockPos)).m_60795_()) continue;
            double offsetX = (level.f_46441_.nextDouble() - 0.5) * (double)maxOffset;
            double offsetZ = (level.f_46441_.nextDouble() - 0.5) * (double)maxOffset;
            float dustChance = 1.0f - (float)(distance / (double)radius);
            if (level.f_46441_.nextFloat() < dustChance * intensity) {
                level.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.6f, 0.5f, 0.4f), 0.8f), x + offsetX, (double)blockPos.m_123342_() + 0.5, z + offsetZ, 1, 0.0, 0.05, 0.0, 0.01);
            }
            if (level.f_46441_.nextFloat() < 0.01f * intensity) {
                level.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockState));
            } else if ((double)level.f_46441_.nextFloat() < 0.5) {
                level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), x, (double)blockPos.m_123342_() + 0.5, z, 5, 0.1, 0.1, 0.1, 0.05);
            }
            if (!(level.f_46441_.nextFloat() < 0.15f * intensity)) continue;
            level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), x, (double)blockPos.m_123342_() + 0.5, z, 2, 0.1 * (double)intensity, 0.1 * (double)intensity, 0.1 * (double)intensity, 0.01);
            if (!(level.f_46441_.nextFloat() < 0.3f * intensity)) continue;
            level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, blockState), x, (double)blockPos.m_123342_() + 1.5 + (double)level.f_46441_.nextFloat(), z, 1, 0.1, 0.0, 0.1, 0.0);
        }
        if (level.f_46441_.nextFloat() < 0.3f * intensity) {
            SoundEvent sound = level.f_46441_.nextFloat() < 0.5f ? SoundEvents.f_12442_ : SoundEvents.f_11993_;
            level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, sound, SoundSource.BLOCKS, 0.2f + 0.8f * intensity, 0.5f + level.f_46441_.nextFloat() * 0.2f);
        }
        if (intensity > 0.7f && level.f_46441_.nextFloat() < 0.1f) {
            level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, 0.3f * intensity, 0.7f + level.f_46441_.nextFloat() * 0.3f);
        }
    }

    private AABB createEffectAABB(Vec3 pos, float radius) {
        return new AABB(pos.f_82479_ - (double)radius, pos.f_82480_ - 2.0, pos.f_82481_ - (double)radius, pos.f_82479_ + (double)radius, pos.f_82480_, pos.f_82481_ + (double)radius);
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            player.f_19853_.m_6263_((Player)player, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12442_, SoundSource.PLAYERS, 0.5f, 0.5f);
            player.m_6330_(SoundEvents.f_12442_, SoundSource.PLAYERS, 1.0f, 0.5f);
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT.writeBits(this.delayTicks, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.delayTicks = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.delayTicks).ifPresent(tag -> nbt.m_128365_("delayTicks", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.delayTicks = Adapters.INT.readNbt(nbt.m_128423_("delayTicks")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.delayTicks).ifPresent(element -> json.add("delayTicks", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.delayTicks = Adapters.INT.readJson(json.get("delayTicks")).orElse(0);
    }
}

