/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.block.entity.LandmineBlockEntity;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.skill.ability.effect.spi.AbstractEarthquakeAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.calc.EffectDurationHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EarthquakeLandmineAbility
extends AbstractEarthquakeAbility {
    private int durationTicks;

    public EarthquakeLandmineAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float radius, float percentAttackDamageDealt, float knockbackStrengthMultiplier, int durationTicks, float blockDestructionChance, float blockReplacementChance) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, radius, percentAttackDamageDealt, knockbackStrengthMultiplier, blockDestructionChance, blockReplacementChance);
        this.durationTicks = durationTicks;
    }

    public EarthquakeLandmineAbility() {
    }

    public int getUnmodifiedDurationTicks() {
        return this.durationTicks;
    }

    public int getDurationTicks(LivingEntity player) {
        return EffectDurationHelper.adjustEffectDurationFloor(player, this.getUnmodifiedDurationTicks());
    }

    @Override
    protected float getDamageModifier(float radius, float dist) {
        return 1.0f;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            BlockPos groundPos = this.findGroundLevel(player.f_19853_, new BlockPos(pos));
            if (groundPos == null) {
                return Ability.ActionResult.fail();
            }
            BlockPos landminePos = groundPos.m_7494_();
            if (!player.f_19853_.m_46859_(landminePos)) {
                return Ability.ActionResult.fail();
            }
            BlockState landmineState = ModBlocks.LANDMINE.m_49966_();
            player.f_19853_.m_7731_(landminePos, landmineState, 3);
            BlockEntity blockEntity = player.f_19853_.m_7702_(landminePos);
            if (!(blockEntity instanceof LandmineBlockEntity)) {
                player.f_19853_.m_7471_(landminePos, false);
                return Ability.ActionResult.fail();
            }
            LandmineBlockEntity landmine = (LandmineBlockEntity)blockEntity;
            landmine.initialize((ServerPlayer)player, this, this.getDurationTicks((LivingEntity)player));
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    private BlockPos findGroundLevel(Level level, BlockPos startPos) {
        BlockPos checkPos = startPos;
        while (checkPos.m_123342_() > level.m_141937_() && level.m_46859_(checkPos.m_7495_())) {
            checkPos = checkPos.m_7495_();
        }
        while (checkPos.m_123342_() < level.m_151558_() && !level.m_46859_(checkPos)) {
            checkPos = checkPos.m_7494_();
        }
        if (checkPos.m_123342_() >= level.m_151558_()) {
            return null;
        }
        return checkPos.m_7495_();
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            player.f_19853_.m_6263_((Player)player, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12449_, SoundSource.PLAYERS, 0.8f, 0.8f);
            player.m_6330_(SoundEvents.f_12449_, SoundSource.PLAYERS, 0.8f, 0.8f);
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT.writeBits(this.durationTicks, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.durationTicks = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.durationTicks).ifPresent(tag -> nbt.m_128365_("durationTicks", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.durationTicks = Adapters.INT.readNbt(nbt.m_128423_("durationTicks")).orElse(1200);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.durationTicks).ifPresent(element -> json.add("durationTicks", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.durationTicks = Adapters.INT.readJson(json.get("durationTicks")).orElse(1200);
    }
}

