/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.common.collect.HashMultimap;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.PlayerStatEvent;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.AbstractEmpowerAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.ToggleAbilityEffect;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.util.calc.PlayerStat;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class EmpowerAbility
extends AbstractEmpowerAbility {
    private static final UUID SPEED_ADDITION_ID = UUID.fromString("8f61de6d-4c50-4b49-a0b4-88dfe2c1050d");
    private float speedPercentAdded;
    private int buffRadius;

    public EmpowerAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCostPerSecond, int durationTicks, float speedPercentAdded) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCostPerSecond, durationTicks);
        this.speedPercentAdded = speedPercentAdded;
    }

    public EmpowerAbility() {
    }

    public float getSpeedPercentAdded() {
        return this.speedPercentAdded;
    }

    public float getUnmodifiedBuffRadius() {
        return this.buffRadius;
    }

    public float getBuffRadius(LivingEntity player) {
        return AreaOfEffectHelper.adjustAreaOfEffect(player, this, this.buffRadius);
    }

    @Override
    protected Ability.ActionResult doToggle(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (this.isActive()) {
                ModEffects.EMPOWER.addTo((LivingEntity)player, 0);
                player.m_21204_().m_22178_(this.getSpeedAttributeModifier());
                return Ability.ActionResult.successCooldownDeferred();
            }
            this.removeEmpower((ServerPlayer)player);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    private HashMultimap<Attribute, AttributeModifier> getSpeedAttributeModifier() {
        HashMultimap attributeMap = HashMultimap.create();
        attributeMap.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(SPEED_ADDITION_ID, "Empower Speed", (double)this.getSpeedPercentAdded(), AttributeModifier.Operation.MULTIPLY_BASE));
        return attributeMap;
    }

    @Override
    protected void doToggleSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            if (this.isActive()) {
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.EMPOWER, SoundSource.MASTER, 0.7f, 1.0f);
                player.m_6330_(ModSounds.EMPOWER, SoundSource.MASTER, 0.7f, 1.0f);
            }
        });
    }

    @Override
    public Ability.TickResult doInactiveTick(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (player.m_21023_((MobEffect)ModEffects.EMPOWER)) {
                this.removeEmpower((ServerPlayer)player);
            }
            return Ability.TickResult.PASS;
        }).orElse(Ability.TickResult.PASS);
    }

    @Override
    public Ability.TickResult doActiveTick(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            float buffRadius = this.getBuffRadius((LivingEntity)player);
            player.m_183503_().m_8795_(anotherPlayer -> player.m_20270_((Entity)anotherPlayer) <= buffRadius && !anotherPlayer.m_142081_().equals(player.m_142081_()) && !anotherPlayer.m_21023_((MobEffect)ModEffects.EMPOWER)).forEach(anotherPlayer -> {
                HashMultimap<Attribute, AttributeModifier> speedAttributeModifier = this.getSpeedAttributeModifier();
                anotherPlayer.m_21204_().m_22178_(speedAttributeModifier);
                anotherPlayer.m_7292_((MobEffectInstance)new EmpowerCoopEffectInstance((Player)player, buffRadius, speedAttributeModifier));
            });
        });
        return super.doActiveTick(context);
    }

    @Override
    protected void doManaDepleted(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(this::removeEmpower);
    }

    @Override
    public void onRemove(SkillContext context) {
        super.onRemove(context);
        context.getSource().as(ServerPlayer.class).ifPresent(this::removeEmpower);
    }

    private void removeEmpower(ServerPlayer entity) {
        entity.m_21195_((MobEffect)ModEffects.EMPOWER);
        entity.m_21204_().m_22161_(this.getSpeedAttributeModifier());
    }

    public static boolean hasEmpowerEffectActive(LivingEntity entity) {
        for (MobEffectInstance instance : entity.m_21220_()) {
            if (!(instance.m_19544_() instanceof EmpowerEffect)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.speedPercentAdded), buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.buffRadius, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.speedPercentAdded = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.buffRadius = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.speedPercentAdded)).ifPresent(tag -> nbt.m_128365_("speedPercentAdded", tag));
            Adapters.INT.writeNbt(this.buffRadius).ifPresent(tag -> nbt.m_128365_("buffRadius", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.speedPercentAdded = Adapters.FLOAT.readNbt(nbt.m_128423_("speedPercentAdded")).orElse(Float.valueOf(0.0f)).floatValue();
        this.buffRadius = Adapters.INT.readNbt(nbt.m_128423_("buffRadius")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.speedPercentAdded)).ifPresent(element -> json.add("speedPercentAdded", element));
            Adapters.INT.writeJson(this.buffRadius).ifPresent(element -> json.add("buffRadius", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.speedPercentAdded = Adapters.FLOAT.readJson(json.get("speedPercentAdded")).orElse(Float.valueOf(0.0f)).floatValue();
        this.buffRadius = Adapters.INT.readJson(json.get("buffRadius")).orElse(0);
    }

    static {
        ((PlayerStatEvent)CommonEvents.PLAYER_STAT.of(PlayerStat.SPEED).filter(data -> data.getEntity().m_21023_((MobEffect)ModEffects.EMPOWER))).register(EmpowerAbility.class, data -> {
            int amplifier = data.getEntity().m_21124_((MobEffect)ModEffects.EMPOWER).m_19564_();
            float speed = (float)(amplifier + 1) / 100.0f;
            data.setValue(data.getValue() + speed);
        });
    }

    public static class EmpowerEffect
    extends ToggleAbilityEffect {
        protected EmpowerEffect(Class<?> type, int color, ResourceLocation resourceLocation) {
            super(type, color, resourceLocation);
        }

        public EmpowerEffect(int color, ResourceLocation resourceLocation) {
            this(EmpowerAbility.class, color, resourceLocation);
        }
    }

    public static class EmpowerCoopEffectInstance
    extends MobEffectInstance {
        private static final int CHECK_INTERVAL = 20;
        private static final int OUT_OF_RANGE_DURATION = 100;
        private long nextCheckTime = Long.MIN_VALUE;
        private final WeakReference<Player> empowerAbilityPlayer;
        private final float playerRange;
        private HashMultimap<Attribute, AttributeModifier> speedAttributeModifier;
        private boolean expired = false;

        public EmpowerCoopEffectInstance(Player empowerAbilityPlayer, float playerRange, HashMultimap<Attribute, AttributeModifier> speedAttributeModifier) {
            super(ModEffects.EMPOWER_COOP, Short.MAX_VALUE, 0, false, false, true);
            this.empowerAbilityPlayer = new WeakReference<Player>(empowerAbilityPlayer);
            this.playerRange = playerRange;
            this.speedAttributeModifier = speedAttributeModifier;
        }

        public boolean m_19552_(LivingEntity livingEntity, Runnable onExpired) {
            if (!livingEntity.m_183503_().m_5776_() && livingEntity.m_183503_().m_46467_() >= this.nextCheckTime) {
                this.nextCheckTime = livingEntity.m_183503_().m_46467_() + 20L;
                this.checkEffectConditions(livingEntity);
            }
            boolean result = super.m_19552_(livingEntity, onExpired);
            if (this.f_19503_ == 0) {
                this.removeSpeedAttribute(livingEntity);
            }
            return result;
        }

        private void checkEffectConditions(LivingEntity livingEntity) {
            ServerPlayer serverPlayer;
            if (this.expired) {
                return;
            }
            Player player = (Player)this.empowerAbilityPlayer.get();
            if (player == null || player.f_19853_ != livingEntity.f_19853_ || player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_9232_() || this.empowerAbilityTurnedOff(player)) {
                this.removeSpeedAttribute(livingEntity);
                this.f_19503_ = 1;
                this.expired = true;
            } else if (livingEntity.m_20270_((Entity)player) > this.playerRange && this.f_19503_ > 100) {
                this.f_19503_ = 100;
            } else if (livingEntity.m_20270_((Entity)player) <= this.playerRange && this.f_19503_ <= 100) {
                this.f_19503_ = Short.MAX_VALUE;
            }
        }

        private void removeSpeedAttribute(LivingEntity livingEntity) {
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.m_21204_().m_22161_(this.speedAttributeModifier);
            }
        }

        private boolean empowerAbilityTurnedOff(Player player) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                return PlayerAbilitiesData.get(serverPlayer.m_183503_()).getAbilities(player).getAll(EmpowerAbility.class, Ability::isActive).isEmpty();
            }
            return true;
        }
    }

    public static class EmpowerCoopEffect
    extends MobEffect {
        public EmpowerCoopEffect(int color, ResourceLocation resourceLocation) {
            super(MobEffectCategory.BENEFICIAL, color);
            this.setRegistryName(resourceLocation);
        }
    }
}

