/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantAbility;
import iskallia.vault.skill.base.SkillContext;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class ExecuteAbility
extends InstantAbility {
    private float damageHealthPercentage;
    private int effectDurationTicks;

    public ExecuteAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float damageHealthPercentage, int effectDurationTicks) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks);
        this.damageHealthPercentage = damageHealthPercentage;
        this.effectDurationTicks = effectDurationTicks;
    }

    public ExecuteAbility() {
    }

    public float getDamageHealthPercentage() {
        return this.damageHealthPercentage;
    }

    public int getEffectDurationTicks() {
        return this.effectDurationTicks;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return Ability.ActionResult.fail();
    }

    @Override
    protected void doParticles(SkillContext context) {
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.EXECUTION_SFX, SoundSource.PLAYERS, 0.4f, 1.0f);
            player.m_6330_(ModSounds.EXECUTION_SFX, SoundSource.PLAYERS, 0.4f, 1.0f);
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.damageHealthPercentage), buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.effectDurationTicks, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.damageHealthPercentage = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.effectDurationTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.damageHealthPercentage)).ifPresent(tag -> nbt.m_128365_("damageHealthPercentage", tag));
            Adapters.INT.writeNbt(this.effectDurationTicks).ifPresent(tag -> nbt.m_128365_("effectDurationTicks", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.damageHealthPercentage = Adapters.FLOAT.readNbt(nbt.m_128423_("damageHealthPercentage")).orElse(Float.valueOf(0.0f)).floatValue();
        this.effectDurationTicks = Adapters.INT.readNbt(nbt.m_128423_("effectDurationTicks")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.damageHealthPercentage)).ifPresent(element -> json.add("damageHealthPercentage", element));
            Adapters.INT.writeJson(this.effectDurationTicks).ifPresent(element -> json.add("effectDurationTicks", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.damageHealthPercentage = Adapters.FLOAT.readJson(json.get("damageHealthPercentage")).orElse(Float.valueOf(0.0f)).floatValue();
        this.effectDurationTicks = Adapters.INT.readJson(json.get("effectDurationTicks")).orElse(0);
    }
}

