/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import iskallia.vault.skill.ability.effect.FarmerAbility;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BambooBlock;
import net.minecraft.world.level.block.BambooSaplingBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.common.ForgeHooks;

public class FarmerCactusAbility
extends FarmerAbility {
    public FarmerCactusAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCostPerSecond, int tickDelay, int horizontalRange, int verticalRange) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCostPerSecond, tickDelay, horizontalRange, verticalRange);
    }

    public FarmerCactusAbility() {
    }

    @Override
    protected boolean canGrowBlock(ServerLevel world, BlockPos pos, Block block, BlockState blockState) {
        if (block instanceof SugarCaneBlock || block instanceof CactusBlock) {
            if (!world.m_46859_(pos.m_7494_())) {
                return false;
            }
            int height = 1;
            while (world.m_8055_(pos.m_6625_(height)).m_60713_(block)) {
                ++height;
            }
            return height < 3;
        }
        if (block instanceof BambooBlock) {
            BambooBlock bambooBlock = (BambooBlock)block;
            if (world.m_8055_(pos.m_7495_()).m_60713_(block)) {
                return false;
            }
            return bambooBlock.m_7370_((BlockGetter)world, pos, blockState, false);
        }
        if (block instanceof BambooSaplingBlock) {
            BambooSaplingBlock bambooSaplingBlock = (BambooSaplingBlock)block;
            if (!world.m_46859_(pos.m_7494_())) {
                return false;
            }
            return bambooSaplingBlock.m_7370_((BlockGetter)world, pos, blockState, false);
        }
        if (block instanceof NetherWartBlock) {
            return (Integer)blockState.m_61143_((Property)NetherWartBlock.f_54967_) < 3;
        }
        return super.canGrowBlock(world, pos, block, blockState);
    }

    @Override
    protected void doGrowBlock(ServerPlayer player, ServerLevel world, BlockPos pos, Block block, BlockState state) {
        super.doGrowBlock(player, world, pos, block, state);
        if (block instanceof SugarCaneBlock || block instanceof CactusBlock) {
            BlockPos above = pos.m_7494_();
            if (ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (boolean)true)) {
                world.m_46597_(above, block.m_49966_());
                BlockState newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61410_, (Comparable)Integer.valueOf(0));
                world.m_7731_(pos, newState, 4);
                newState.m_60690_((Level)world, above, block, pos, false);
                world.m_186464_(above, block, 1, TickPriority.EXTREMELY_HIGH);
                ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)above, (BlockState)state);
                world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 20, 0.5, 0.5, 0.5, 0.0);
            }
        } else if (block instanceof BambooBlock || block instanceof BambooSaplingBlock) {
            BlockState blockState = world.m_8055_(pos);
            Block block2 = blockState.m_60734_();
            if (block2 instanceof BonemealableBlock) {
                BonemealableBlock bonemealableBlock = (BonemealableBlock)block2;
                bonemealableBlock.m_7719_(world, world.f_46441_, pos, blockState);
            }
            BlockPos bambooBlockPos = pos.m_7494_();
            ArrayList<BlockPos> particlePosList = new ArrayList<BlockPos>();
            while (world.m_8055_(bambooBlockPos).m_60713_(block)) {
                particlePosList.add(bambooBlockPos);
                bambooBlockPos = bambooBlockPos.m_7494_();
            }
            for (BlockPos blockPos : particlePosList) {
                world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, Math.max(1, 20 / particlePosList.size()), 0.5, 0.5, 0.5, 0.0);
            }
        } else if (block instanceof NetherWartBlock) {
            BlockState blockState = world.m_8055_(pos);
            if (ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)blockState, (boolean)true)) {
                blockState = (BlockState)blockState.m_61124_((Property)NetherWartBlock.f_54967_, (Comparable)Integer.valueOf((Integer)blockState.m_61143_((Property)NetherWartBlock.f_54967_) + 1));
                world.m_7731_(pos, blockState, 2);
                ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)blockState);
            }
            world.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.0);
        }
    }
}

