/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.entity.Targeting;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.calc.EffectDurationHelper;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GhostWalkAbility
extends InstantManaAbility {
    private int durationTicks;

    public GhostWalkAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int durationTicks) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.durationTicks = durationTicks;
    }

    public GhostWalkAbility() {
    }

    protected MobEffect getEffect() {
        return ModEffects.GHOST_WALK;
    }

    public int getUnmodifiedDurationTicks() {
        return this.durationTicks;
    }

    public int getDurationTicks(LivingEntity entity) {
        return EffectDurationHelper.adjustEffectDurationFloor(entity, this.getUnmodifiedDurationTicks());
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (player.m_21023_(this.getEffect())) {
                return Ability.ActionResult.fail();
            }
            int duration = this.getDurationTicks((LivingEntity)player);
            MobEffectInstance newEffect = new MobEffectInstance(this.getEffect(), duration, 0, false, false, true);
            player.m_7292_(newEffect);
            return Ability.ActionResult.successCooldownDeferred();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.GHOST_WALK_SFX, SoundSource.PLAYERS, 0.2f, 1.0f);
            player.m_6330_(ModSounds.GHOST_WALK_SFX, SoundSource.PLAYERS, 0.2f, 1.0f);
        });
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onDamage(LivingDamageEvent event) {
        Entity attacker = event.getSource().m_7639_();
        if (attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
            for (GhostWalkAbility ability : abilities.getAll(GhostWalkAbility.class, Skill::isUnlocked)) {
                if (!ability.doRemoveWhenDealingDamage() || !player.m_21023_(ability.getEffect())) continue;
                player.m_21195_(ability.getEffect());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onHurt(LivingHurtEvent event) {
        if (GhostWalkAbility.isInvulnerable(event.getEntityLiving(), event.getSource())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onAttack(LivingAttackEvent event) {
        if (GhostWalkAbility.isInvulnerable(event.getEntityLiving(), event.getSource())) {
            event.setCanceled(true);
        }
    }

    public static boolean isInvulnerable(@Nullable LivingEntity entity, @Nullable DamageSource source) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
            for (GhostWalkAbility ability : abilities.getAll(GhostWalkAbility.class, Skill::isUnlocked)) {
                if (!player.m_21023_(ability.getEffect()) || !ability.preventsDamage() || source != null && source.m_19378_()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean preventsDamage() {
        return true;
    }

    protected boolean doRemoveWhenDealingDamage() {
        return true;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.durationTicks, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.durationTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.durationTicks).ifPresent(tag -> nbt.m_128365_("durationTicks", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.durationTicks = Adapters.INT.readNbt(nbt.m_128423_("durationTicks")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.durationTicks).ifPresent(element -> json.add("durationTicks", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.durationTicks = Adapters.INT.readJson(json.get("durationTicks")).orElse(0);
    }

    static {
        Targeting.addIgnoredTargetOverride((attacker, target) -> {
            LivingEntity livingEntity;
            return target instanceof LivingEntity && GhostWalkAbility.isInvulnerable(livingEntity = (LivingEntity)target, null);
        });
    }

    public static class GhostWalkEffect
    extends MobEffect {
        public GhostWalkEffect(MobEffectCategory typeIn, int liquidColorIn, ResourceLocation id) {
            super(typeIn, liquidColorIn);
            this.setRegistryName(id);
        }

        @ParametersAreNonnullByDefault
        public void m_6386_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                PlayerAbilitiesData.setAbilityOnCooldown(player, GhostWalkAbility.class);
            }
            super.m_6386_(livingEntity, attributeMap, amplifier);
        }
    }
}

