/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.mojang.datafixers.util.Pair;
import iskallia.vault.VaultMod;
import iskallia.vault.gear.etching.EtchingGearAttributes;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEffects;
import iskallia.vault.mixin.AccessorServerPlayerGameMode;
import iskallia.vault.skill.ability.effect.GhostWalkAbility;
import iskallia.vault.skill.ability.effect.spi.core.InstantAbility;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.world.data.PlayerAbilitiesData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GhostWalkSpiritAbility
extends GhostWalkAbility {
    public GhostWalkSpiritAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int durationTicks) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, durationTicks);
    }

    public GhostWalkSpiritAbility() {
    }

    @Override
    protected MobEffect getEffect() {
        return ModEffects.GHOST_WALK_SPIRIT_WALK;
    }

    @SubscribeEvent
    public static void on(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (((AccessorServerPlayerGameMode)player2.f_8941_).isDestroyingBlock()) {
                AbilityTree abilities = PlayerAbilitiesData.get(player2.m_183503_()).getAbilities((Player)player2);
                for (GhostWalkSpiritAbility ability : abilities.getAll(GhostWalkSpiritAbility.class, Skill::isUnlocked)) {
                    player2.m_21195_(ability.getEffect());
                }
            }
        }
    }

    @SubscribeEvent
    public static void on(PlayerContainerEvent.Open event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AbilityTree abilities = PlayerAbilitiesData.get(player2.m_183503_()).getAbilities((Player)player2);
            for (GhostWalkSpiritAbility ability : abilities.getAll(GhostWalkSpiritAbility.class, Skill::isUnlocked)) {
                player2.m_21195_(ability.getEffect());
            }
        }
    }

    public static class SpiritWalkEffect
    extends GhostWalkAbility.GhostWalkEffect {
        public SpiritWalkEffect(MobEffectCategory category, int color, ResourceLocation id) {
            super(category, color, id);
        }

        @Override
        public void m_6386_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.SPIRIT_WALK_ABILITY).stream().findFirst().ifPresent(stack -> {
                    String abilityId = (String)((Pair)stack.getValue()).getFirst();
                    int level = (Integer)((Pair)stack.getValue()).getSecond();
                    ModConfigs.ABILITIES.getAbilityById(abilityId).filter(s -> s instanceof TieredSkill).map(s -> (TieredSkill)s).ifPresent(tiered -> {
                        int idx = Mth.m_14045_((int)level, (int)1, (int)tiered.getTiers().size());
                        LearnableSkill child = tiered.getChild(idx);
                        if (child instanceof InstantAbility) {
                            InstantAbility ability = (InstantAbility)child;
                            ability.onAction(SkillContext.of(player));
                        } else {
                            VaultMod.LOGGER.error("SpiritWalkNovaEtching ability {} level {} is not InstantAbility", (Object)abilityId, (Object)idx);
                        }
                    });
                });
            }
            super.m_6386_(livingEntity, attributeMap, amplifier);
        }
    }
}

