/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.entity.entity.VaultGrenade;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.util.damage.PlayerDamageHelper;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class GrenadeAbility
extends InstantManaAbility {
    private float percentAttackDamageDealt;
    private float radius;
    private int duration;
    private float throwPower = 1.0f;

    public GrenadeAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float percentAttackDamageDealt, float radius, int duration, float throwPower) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.percentAttackDamageDealt = percentAttackDamageDealt;
        this.radius = radius;
        this.duration = duration;
        this.throwPower = throwPower;
    }

    public GrenadeAbility() {
    }

    public float getPercentAttackDamageDealt() {
        return this.percentAttackDamageDealt;
    }

    public float getUnmodifiedRadius() {
        return this.radius;
    }

    public float getRadius(Entity attacker) {
        float r = this.getUnmodifiedRadius();
        if (attacker instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)attacker;
            r = AreaOfEffectHelper.adjustAreaOfEffect(living, this, r);
        }
        return r;
    }

    public int getDuration() {
        return this.duration;
    }

    protected float getAttackDamage(ServerPlayer player) {
        float base = (float)player.m_21133_(Attributes.f_22281_);
        float attackDamagePercentageIncrease = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player).getAttributeValue(ModGearAttributes.DAMAGE_INCREASE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        float increase = base * attackDamagePercentageIncrease;
        float damage = (base += increase) * this.getPercentAttackDamageDealt();
        return damage * PlayerDamageHelper.getDamageMultiplier((Player)player, true, false);
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            VaultGrenade grenade = new VaultGrenade(player.f_19853_, (LivingEntity)player, this.getAttackDamage((ServerPlayer)player), this.getRadius((Entity)player), this.getDuration());
            grenade.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.throwPower, 0.0f);
            player.f_19853_.m_7967_((Entity)grenade);
            player.f_19853_.m_6269_(null, (Entity)player, SoundEvents.f_12473_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    public float getThrowPower() {
        return this.throwPower;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentAttackDamageDealt), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.radius), buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.duration, buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.throwPower), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.percentAttackDamageDealt = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(0.0f)).floatValue();
        this.radius = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(0.0f)).floatValue();
        this.duration = Adapters.INT_SEGMENTED_3.readBits(buffer).orElse(0);
        this.throwPower = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentAttackDamageDealt)).ifPresent(t -> nbt.m_128365_("percentAttackDamageDealt", t));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.radius)).ifPresent(t -> nbt.m_128365_("radius", t));
            Adapters.INT.writeNbt(this.duration).ifPresent(t -> nbt.m_128365_("duration", t));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.throwPower)).ifPresent(t -> nbt.m_128365_("throwPower", t));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.percentAttackDamageDealt = Adapters.FLOAT.readNbt(nbt.m_128423_("percentAttackDamageDealt")).orElse(Float.valueOf(0.0f)).floatValue();
        this.radius = Adapters.FLOAT.readNbt(nbt.m_128423_("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.duration = Adapters.INT.readNbt(nbt.m_128423_("duration")).orElse(0);
        this.throwPower = Adapters.FLOAT.readNbt(nbt.m_128423_("throwPower")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentAttackDamageDealt)).ifPresent(e -> json.add("percentAttackDamageDealt", e));
            Adapters.FLOAT.writeJson(Float.valueOf(this.radius)).ifPresent(e -> json.add("radius", e));
            Adapters.INT.writeJson(this.duration).ifPresent(e -> json.add("duration", e));
            Adapters.FLOAT.writeJson(Float.valueOf(this.throwPower)).ifPresent(e -> json.add("throwPower", e));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.percentAttackDamageDealt = Adapters.FLOAT.readJson(json.get("percentAttackDamageDealt")).orElse(Float.valueOf(0.0f)).floatValue();
        this.radius = Adapters.FLOAT.readJson(json.get("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.duration = Adapters.INT.readJson(json.get("duration")).orElse(0);
        this.throwPower = Adapters.FLOAT.readJson(json.get("throwPower")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

