/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.AbstractHealAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.player.Player;

public class HealEffectAbility
extends AbstractHealAbility {
    private List<MobEffect> removeEffects;
    private RemovalStrategy removalStrategy;
    private static final ArrayAdapter<MobEffect> EFFECTS = Adapters.ofArray(MobEffect[]::new, Adapters.EFFECT.asNullable());
    private static final EnumAdapter<RemovalStrategy> STRATEGY_ORDINAL = Adapters.ofEnum(RemovalStrategy.class, EnumAdapter.Mode.ORDINAL);
    private static final EnumAdapter<RemovalStrategy> STRATEGY_NAME = Adapters.ofEnum(RemovalStrategy.class, EnumAdapter.Mode.NAME);

    public HealEffectAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, List<MobEffect> removeEffects, RemovalStrategy removalStrategy) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.removeEffects = removeEffects;
        this.removalStrategy = removalStrategy;
    }

    public HealEffectAbility() {
    }

    public List<MobEffect> getRemoveEffects() {
        return this.removeEffects;
    }

    public RemovalStrategy getRemovalStrategy() {
        return this.removalStrategy;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            this.removalStrategy.apply((ServerPlayer)player, this);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doParticles(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123772_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 50, 1.0, 0.5, 1.0, 0.0);
            ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123748_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 50, 1.0, 0.5, 1.0, 0.0);
        });
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.CLEANSE_SFX, SoundSource.PLAYERS, 0.2f, 1.0f);
            player.m_6330_(ModSounds.CLEANSE_SFX, SoundSource.PLAYERS, 0.2f, 1.0f);
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        EFFECTS.writeBits((MobEffect)((MobEffect[])this.removeEffects.toArray(MobEffect[]::new)), buffer);
        STRATEGY_ORDINAL.writeBits(this.removalStrategy, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.removeEffects = Arrays.stream((MobEffect[])EFFECTS.readBits(buffer).orElseThrow()).collect(Collectors.toList());
        this.removeEffects.removeIf(Objects::isNull);
        this.removalStrategy = STRATEGY_ORDINAL.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            EFFECTS.writeNbt((MobEffect)((MobEffect[])this.removeEffects.toArray(MobEffect[]::new))).ifPresent(tag -> nbt.m_128365_("removeEffects", tag));
            STRATEGY_NAME.writeNbt(this.removalStrategy).ifPresent(tag -> nbt.m_128365_("removalStrategy", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.removeEffects = Arrays.stream(EFFECTS.readNbt(nbt.m_128423_("removeEffects")).orElse(new MobEffect[0])).collect(Collectors.toList());
        this.removeEffects.removeIf(Objects::isNull);
        this.removalStrategy = STRATEGY_NAME.readNbt(nbt.m_128423_("removalStrategy")).orElse(RemovalStrategy.ALL_HARMFUL);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            EFFECTS.writeJson((MobEffect)((MobEffect[])this.removeEffects.toArray(MobEffect[]::new))).ifPresent(element -> json.add("removeEffects", element));
            STRATEGY_NAME.writeJson(this.removalStrategy).ifPresent(element -> json.add("removalStrategy", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.removeEffects = Arrays.stream(EFFECTS.readJson(json.get("removeEffects")).orElse(new MobEffect[0])).collect(Collectors.toList());
        this.removeEffects.removeIf(Objects::isNull);
        this.removalStrategy = STRATEGY_NAME.readJson(json.get("removalStrategy")).orElse(RemovalStrategy.ALL_HARMFUL);
    }

    public static enum RemovalStrategy implements IRemovalStrategy
    {
        DEFINED_ONLY((player, config) -> config.getRemoveEffects().forEach(arg_0 -> ((ServerPlayer)player).m_21195_(arg_0))),
        ALL_HARMFUL((player, config) -> new ArrayList(player.m_21220_()).stream().filter(instance -> instance.m_19544_().m_19483_() == MobEffectCategory.HARMFUL).forEach(instance -> player.m_21195_(instance.m_19544_())));

        private final IRemovalStrategy removalStrategy;

        private RemovalStrategy(IRemovalStrategy removalStrategy) {
            this.removalStrategy = removalStrategy;
        }

        @Override
        public void apply(ServerPlayer player, HealEffectAbility config) {
            this.removalStrategy.apply(player, config);
        }
    }

    @FunctionalInterface
    private static interface IRemovalStrategy {
        public void apply(ServerPlayer var1, HealEffectAbility var2);
    }
}

