/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.EntityStunnedEvent;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.entity.entity.IceBoltEntity;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.etching.EtchingGearAttributes;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.AbstractIceBoltAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.Throuple;
import iskallia.vault.util.calc.EffectDurationHelper;
import iskallia.vault.util.damage.AttackScaleHelper;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class IceBoltArrowAbility
extends AbstractIceBoltAbility {
    private int durationTicks;
    private int amplifier;

    public int getDurationTicksUnmodified() {
        return this.durationTicks;
    }

    public int getDurationTicks(LivingEntity entity) {
        int duration = this.getDurationTicksUnmodified();
        return EffectDurationHelper.adjustEffectDurationFloor(entity, duration);
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            boolean luckyEtching = EtchingHelper.hasEtching((LivingEntity)player, EtchingGearAttributes.ICE_BOLT_LUCKY);
            if (luckyEtching) {
                AttackScaleHelper.setLastAttackScale((Player)player, 1.0f);
            }
            IceBoltEntity entity = new IceBoltEntity((LivingEntity)player, IceBoltEntity.Model.ARROW, result -> {
                EntityHitResult hit;
                Entity patt2295$temp;
                if (!(result instanceof EntityHitResult) || !((patt2295$temp = (hit = (EntityHitResult)result).m_82443_()) instanceof LivingEntity)) {
                    return;
                }
                LivingEntity living = (LivingEntity)patt2295$temp;
                living.m_7292_(new MobEffectInstance(ModEffects.CHILLED, this.getDurationTicks((LivingEntity)player), this.getAmplifier(), false, false, false));
                EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.ICE_BOLT_EFFECT_ETCHING).stream().findFirst().ifPresent(stack -> {
                    MobEffect effect;
                    float chance = ((Float)((Throuple)stack.getValue()).getSecond()).floatValue();
                    int duration = (Integer)((Throuple)stack.getValue()).getThird();
                    String id = (String)((Throuple)stack.getValue()).getFirst();
                    if (player.f_19853_.f_46441_.nextFloat() <= chance && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(id))) != null) {
                        living.m_7292_(new MobEffectInstance(effect, duration * 20));
                    }
                });
                CommonEvents.ENTITY_STUNNED.invoke(new EntityStunnedEvent.Data((LivingEntity)player, living));
            });
            boolean allowPvP = VaultUtils.getVault(player.f_19853_).map(VaultUtils::isPvPVault).orElse(false);
            entity.setAllowLuckyHit(luckyEtching);
            entity.setAllowPvP(allowPvP);
            entity.m_36781_(this.getDamagePerBolt());
            int pierce = EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.ICE_BOLT_PIERCE).stream().findFirst().map(VaultGearAttributeInstance::getValue).orElse(0);
            entity.m_36767_((byte)pierce);
            entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.getThrowPower(), 0.0f);
            player.f_19853_.m_7967_((Entity)entity);
            player.f_19853_.m_6269_(null, (Entity)player, ModSounds.ICE_BOLT_ARROW, SoundSource.PLAYERS, 0.3f, player.f_19853_.f_46441_.nextFloat() * 0.6f + 0.8f);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.durationTicks, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.amplifier, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.durationTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.amplifier = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT_SEGMENTED_7.writeNbt(this.durationTicks).ifPresent(tag -> nbt.m_128365_("durationTicks", tag));
            Adapters.INT_SEGMENTED_3.writeNbt(this.amplifier).ifPresent(tag -> nbt.m_128365_("amplifier", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.durationTicks = Adapters.INT_SEGMENTED_7.readNbt(nbt.m_128423_("durationTicks")).orElse(0);
        this.amplifier = Adapters.INT_SEGMENTED_3.readNbt(nbt.m_128423_("amplifier")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT_SEGMENTED_7.writeJson(this.durationTicks).ifPresent(tag -> json.add("durationTicks", tag));
            Adapters.INT_SEGMENTED_3.writeJson(this.amplifier).ifPresent(tag -> json.add("amplifier", tag));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.durationTicks = Adapters.INT_SEGMENTED_7.readJson(json.get("durationTicks")).orElse(0);
        this.amplifier = Adapters.INT_SEGMENTED_3.readJson(json.get("amplifier")).orElse(0);
    }
}

