/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.EntityStunnedEvent;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.entity.entity.IceBoltEntity;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.etching.EtchingGearAttributes;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.StonefallFrostParticleMessage;
import iskallia.vault.skill.ability.effect.spi.AbstractIceBoltAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.AABBHelper;
import iskallia.vault.util.Throuple;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.util.calc.EffectDurationHelper;
import iskallia.vault.util.damage.AttackScaleHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class IceBoltChunkAbility
extends AbstractIceBoltAbility {
    private float radius;
    private int durationTicks;
    private int amplifier;
    private float glacialChance;

    public float getUnmodifiedRadius() {
        return this.radius;
    }

    public float getRadius(Entity attacker) {
        float realRadius = this.getUnmodifiedRadius();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            realRadius = AreaOfEffectHelper.adjustAreaOfEffect(livingEntity, this, realRadius);
        }
        return realRadius;
    }

    public int getDurationTicksUnmodified() {
        return this.durationTicks;
    }

    public int getDurationTicks(LivingEntity entity) {
        int duration = this.getDurationTicksUnmodified();
        return EffectDurationHelper.adjustEffectDurationFloor(entity, duration);
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public float getGlacialChance() {
        return this.glacialChance;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            boolean luckyEtching = EtchingHelper.hasEtching((LivingEntity)player, EtchingGearAttributes.ICE_BOLT_LUCKY);
            if (luckyEtching) {
                AttackScaleHelper.setLastAttackScale((Player)player, 1.0f);
            }
            IceBoltEntity arrow = new IceBoltEntity((LivingEntity)player, IceBoltEntity.Model.CHUNK, result -> {
                float radius = this.getRadius((Entity)player);
                Vec3 pos = result.m_82450_();
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StonefallFrostParticleMessage(pos, this.getRadius((Entity)player)));
                player.f_19853_.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, ModSounds.NOVA_SPEED, SoundSource.PLAYERS, 0.2f, 1.0f);
                List nearbyEntities = player.f_19853_.m_45971_(LivingEntity.class, TargetingConditions.m_148352_().m_26888_(entity -> VaultUtils.getVault(player.f_19853_).map(VaultUtils::isPvPVault).orElse(false) != false || !(entity instanceof Player)).m_26883_(1000.0), (LivingEntity)player, AABBHelper.create(pos, radius));
                for (LivingEntity nearbyEntity : nearbyEntities) {
                    nearbyEntity.m_7292_(new MobEffectInstance(ModEffects.CHILLED, this.getDurationTicks((LivingEntity)player), this.getAmplifier(), false, false, false));
                    CommonEvents.ENTITY_STUNNED.invoke(new EntityStunnedEvent.Data((LivingEntity)player, nearbyEntity));
                    if (!(player.f_19853_.f_46441_.nextFloat() <= this.glacialChance) || ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id("elite"), (Entity)nearbyEntity)) continue;
                    nearbyEntity.m_21195_(ModEffects.GLACIAL_SHATTER);
                    nearbyEntity.m_7292_(new MobEffectInstance(ModEffects.GLACIAL_SHATTER, this.getDurationTicks((LivingEntity)player), this.getAmplifier()));
                    EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.ICE_BOLT_EFFECT_ETCHING).stream().findFirst().ifPresent(stack -> {
                        MobEffect effect;
                        float chance = ((Float)((Throuple)stack.getValue()).getSecond()).floatValue();
                        int duration = (Integer)((Throuple)stack.getValue()).getThird();
                        String id = (String)((Throuple)stack.getValue()).getFirst();
                        if (player.f_19853_.f_46441_.nextFloat() <= chance && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(id))) != null) {
                            nearbyEntity.m_7292_(new MobEffectInstance(effect, duration * 20));
                        }
                    });
                    player.f_19853_.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11983_, SoundSource.BLOCKS, 0.25f, 0.65f);
                }
            });
            boolean allowPvP = VaultUtils.getVault(player.f_19853_).map(VaultUtils::isPvPVault).orElse(false);
            arrow.setAllowLuckyHit(luckyEtching);
            arrow.setAllowPvP(allowPvP);
            double damage = this.getDamagePerBolt();
            Optional dmgEtch = EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.ICE_BOLT_CHUNK_DAMAGE).stream().findFirst();
            if (dmgEtch.isPresent()) {
                float percent = ((Float)((VaultGearAttributeInstance)dmgEtch.get()).getValue()).floatValue();
                damage = player.m_21133_(Attributes.f_22281_) * (double)percent;
            }
            arrow.m_36781_(damage);
            int pierce = EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.ICE_BOLT_PIERCE).stream().findFirst().map(VaultGearAttributeInstance::getValue).orElse(0);
            arrow.m_36767_((byte)pierce);
            arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.getThrowPower(), 0.0f);
            player.f_19853_.m_7967_((Entity)arrow);
            player.f_19853_.m_6269_(null, (Entity)player, ModSounds.ICE_BOLT_CHUNK, SoundSource.PLAYERS, 1.0f, player.f_19853_.f_46441_.nextFloat() * 0.3f + 0.9f);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.radius), buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.durationTicks, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.amplifier, buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.glacialChance), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.radius = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.durationTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.amplifier = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.glacialChance = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.radius)).ifPresent(tag -> nbt.m_128365_("radius", tag));
            Adapters.INT_SEGMENTED_7.writeNbt(this.durationTicks).ifPresent(tag -> nbt.m_128365_("durationTicks", tag));
            Adapters.INT_SEGMENTED_3.writeNbt(this.amplifier).ifPresent(tag -> nbt.m_128365_("amplifier", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.glacialChance)).ifPresent(tag -> nbt.m_128365_("glacialChance", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.radius = Adapters.FLOAT.readNbt(nbt.m_128423_("radius")).orElse(Float.valueOf(1.0f)).floatValue();
        this.durationTicks = Adapters.INT_SEGMENTED_7.readNbt(nbt.m_128423_("durationTicks")).orElse(0);
        this.amplifier = Adapters.INT_SEGMENTED_3.readNbt(nbt.m_128423_("amplifier")).orElse(0);
        this.glacialChance = Adapters.FLOAT.readNbt(nbt.m_128423_("glacialChance")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.radius)).ifPresent(tag -> json.add("radius", tag));
            Adapters.INT_SEGMENTED_7.writeJson(this.durationTicks).ifPresent(tag -> json.add("durationTicks", tag));
            Adapters.INT_SEGMENTED_3.writeJson(this.amplifier).ifPresent(tag -> json.add("amplifier", tag));
            Adapters.FLOAT.writeJson(Float.valueOf(this.glacialChance)).ifPresent(tag -> json.add("glacialChance", tag));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.radius = Adapters.FLOAT.readJson(json.get("radius")).orElse(Float.valueOf(1.0f)).floatValue();
        this.durationTicks = Adapters.INT_SEGMENTED_7.readJson(json.get("durationTicks")).orElse(0);
        this.amplifier = Adapters.INT_SEGMENTED_3.readJson(json.get("amplifier")).orElse(0);
        this.glacialChance = Adapters.FLOAT.readJson(json.get("glacialChance")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

