/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.entity.entity.VaultThrownJavelin;
import iskallia.vault.gear.etching.EtchingGearAttributes;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.mana.FullManaPlayer;
import iskallia.vault.skill.ability.effect.spi.AbstractJavelinAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.talent.type.JavelinFrugalTalent;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.world.data.PlayerTalentsData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;

public class JavelinPiercingAbility
extends AbstractJavelinAbility {
    private int piercing;

    public JavelinPiercingAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float percentAttackDamageDealt, float throwPower, int piercing) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, percentAttackDamageDealt, throwPower);
        this.piercing = piercing;
    }

    public JavelinPiercingAbility() {
    }

    public int getPiercing() {
        return this.piercing;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            VaultThrownJavelin thrownJavelin = new VaultThrownJavelin(player.f_19853_, (LivingEntity)player);
            boolean allowPvP = VaultUtils.getVault(player.f_19853_).map(VaultUtils::isPvPVault).orElse(false);
            thrownJavelin.setAllowPvP(allowPvP);
            thrownJavelin.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.getThrowPower((ServerPlayer)player), 1.0f);
            thrownJavelin.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            thrownJavelin.setType(VaultThrownJavelin.JavelinType.PIERCING);
            thrownJavelin.setDamage(this.getAttackDamage((ServerPlayer)player));
            TalentTree talents = PlayerTalentsData.get(player.m_183503_()).getTalents((Player)player);
            for (JavelinFrugalTalent talent : talents.getAll(JavelinFrugalTalent.class, Skill::isUnlocked)) {
                if (!(talent.getFrugalChance() >= player.m_21187_().nextFloat())) continue;
                context.getSource().setMana(FullManaPlayer.INSTANCE);
                thrownJavelin.setIsGhost();
            }
            player.f_19853_.m_7967_((Entity)thrownJavelin);
            EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.PIERCING_JAVELIN).stream().findFirst().ifPresent(stack -> {
                float mult = ((Float)stack.getValue()).floatValue();
                this.spawnExtraJavelin((ServerPlayer)player, talents, context, player.m_146908_() - 10.0f, mult);
                this.spawnExtraJavelin((ServerPlayer)player, talents, context, player.m_146908_() + 10.0f, mult);
            });
            player.f_19853_.m_6269_(null, (Entity)thrownJavelin, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    private void spawnExtraJavelin(ServerPlayer player, TalentTree talents, SkillContext context, float yaw, float damageMult) {
        VaultThrownJavelin extra = new VaultThrownJavelin(player.f_19853_, (LivingEntity)player);
        boolean allowPvP = VaultUtils.getVault(player.f_19853_).map(VaultUtils::isPvPVault).orElse(false);
        extra.setAllowPvP(allowPvP);
        extra.m_37251_((Entity)player, player.m_146909_(), yaw, 0.0f, this.getThrowPower(player), 1.0f);
        extra.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        extra.setType(VaultThrownJavelin.JavelinType.PIERCING);
        extra.setDamage(this.getAttackDamage(player) * damageMult);
        for (JavelinFrugalTalent talent : talents.getAll(JavelinFrugalTalent.class, Skill::isUnlocked)) {
            if (!(talent.getFrugalChance() >= player.m_21187_().nextFloat())) continue;
            context.getSource().setMana(FullManaPlayer.INSTANCE);
            extra.setIsGhost();
        }
        player.f_19853_.m_7967_((Entity)extra);
    }

    @Override
    protected void doParticles(SkillContext context) {
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.piercing, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.piercing = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.piercing).ifPresent(tag -> nbt.m_128365_("piercing", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.piercing = Adapters.INT.readNbt(nbt.m_128423_("piercing")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.piercing).ifPresent(element -> json.add("piercing", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.piercing = Adapters.INT.readJson(json.get("piercing")).orElse(0);
    }
}

