/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import iskallia.vault.client.particles.SphericalParticleOptions;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModParticles;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.AABBHelper;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LifeTapAbility
extends InstantAbility {
    private float radius;
    private float percentHealthDrained;
    private double damagePerHealth;

    public LifeTapAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float radius, float percentHealthDrained, double damagePerHealth) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks);
        this.radius = radius;
        this.percentHealthDrained = percentHealthDrained;
        this.damagePerHealth = damagePerHealth;
    }

    public LifeTapAbility() {
    }

    public float getPercentHealthDrained() {
        return this.percentHealthDrained;
    }

    public double getDamagePerHealth() {
        return this.damagePerHealth;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            List<LivingEntity> targets = this.getTargetEntities(player.f_19853_, (LivingEntity)player, pos);
            DamageSource damageSource = DamageSource.m_19344_((Player)player);
            float currentHealth = player.m_21223_();
            float drain = currentHealth * this.getPercentHealthDrained();
            float damage = (float)((double)drain * this.getDamagePerHealth());
            for (LivingEntity entity : targets) {
                if (entity.m_6673_(damageSource)) continue;
                float modifier = this.getDamageModifier(this.getRadius((Entity)player), player.m_20270_((Entity)entity));
                float finalDamage = damage * modifier;
                ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> entity.m_6469_(damageSource, finalDamage));
            }
            float newHealth = Math.max(1.0f, currentHealth - drain);
            player.m_21153_(newHealth);
            player.m_183503_().m_8767_((ParticleOptions)new SphericalParticleOptions((ParticleType<SphericalParticleOptions>)((ParticleType)ModParticles.IMPLODE.get()), this.getRadius((Entity)player), new Vector3f(1.0f, 0.0f, 0.0f)), player.m_20185_(), player.m_20186_(), player.m_20189_(), 400, 0.0, 0.0, 0.0, 0.0);
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.LIFE_TAP, SoundSource.PLAYERS, 0.2f, 0.2f);
            player.m_6330_(ModSounds.LIFE_TAP, SoundSource.PLAYERS, 0.2f, 0.2f);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    protected float getDamageModifier(float radius, float dist) {
        if (dist >= 0.0f && dist < radius / 5.0f * 1.0f) {
            return 1.0f;
        }
        if (dist >= radius / 5.0f * 1.0f && dist < radius / 5.0f * 2.0f) {
            return 0.8f;
        }
        if (dist >= radius / 5.0f * 2.0f && dist < radius / 5.0f * 3.0f) {
            return 0.6f;
        }
        if (dist >= radius / 5.0f * 3.0f && dist < radius / 5.0f * 4.0f) {
            return 0.4f;
        }
        if (dist >= radius / 5.0f * 4.0f) {
            return 0.2f;
        }
        return 0.2f;
    }

    public float getUnmodifiedRadius() {
        return this.radius;
    }

    public float getRadius(Entity attacker) {
        float realRadius = this.getUnmodifiedRadius();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            realRadius = AreaOfEffectHelper.adjustAreaOfEffect(livingEntity, this, realRadius);
        }
        return realRadius;
    }

    @NotNull
    protected List<LivingEntity> getTargetEntities(Level world, LivingEntity attacker, Vec3 pos) {
        float radius = this.getRadius((Entity)attacker);
        return world.m_45971_(LivingEntity.class, TargetingConditions.m_148352_().m_26883_((double)radius).m_26888_(arg_0 -> LifeTapAbility.lambda$getTargetEntities$2(attacker, arg_0)), attacker, AABBHelper.create(pos, radius));
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.radius), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentHealthDrained), buffer);
        Adapters.DOUBLE.writeBits(this.damagePerHealth, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.radius = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.percentHealthDrained = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.damagePerHealth = (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.radius)).ifPresent(tag -> nbt.m_128365_("radius", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentHealthDrained)).ifPresent(tag -> nbt.m_128365_("percentHealthDrained", tag));
            Adapters.DOUBLE.writeNbt(this.damagePerHealth).ifPresent(tag -> nbt.m_128365_("damagePerHealth", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.radius = Adapters.FLOAT.readNbt(nbt.m_128423_("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.percentHealthDrained = Adapters.FLOAT.readNbt(nbt.m_128423_("percentHealthDrained")).orElse(Float.valueOf(0.0f)).floatValue();
        this.damagePerHealth = Adapters.DOUBLE.readNbt(nbt.m_128423_("damagePerHealth")).orElse(0.0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.radius)).ifPresent(element -> json.add("radius", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentHealthDrained)).ifPresent(element -> json.add("percentHealthDrained", element));
            Adapters.DOUBLE.writeJson(this.damagePerHealth).ifPresent(element -> json.add("damagePerHealth", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.radius = Adapters.FLOAT.readJson(json.get("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.percentHealthDrained = Adapters.FLOAT.readJson(json.get("percentHealthDrained")).orElse(Float.valueOf(0.0f)).floatValue();
        this.damagePerHealth = Adapters.DOUBLE.readJson(json.get("damagePerHealth")).orElse(0.0);
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ boolean lambda$getTargetEntities$2(LivingEntity attacker, LivingEntity entity) {
        if (!(attacker instanceof ServerPlayer)) ** GOTO lbl-1000
        sPlayer = (ServerPlayer)attacker;
        if (VaultUtils.getVault(sPlayer.f_19853_).map((Function<Vault, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, isPvPVault(iskallia.vault.core.vault.Vault ), (Liskallia/vault/core/vault/Vault;)Ljava/lang/Boolean;)()).orElse(false).booleanValue()) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        pvp = v0;
        return (pvp != false || entity instanceof Player == false) && entity instanceof EternalEntity == false && entity instanceof PetEntity == false;
    }
}

