/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.entity.entity.LightningOrbEntity;
import iskallia.vault.skill.ability.effect.spi.AbstractChainLightningAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.calc.EffectDurationHelper;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class LightningOrbsAbility
extends AbstractChainLightningAbility {
    private int durationTicks;
    private float orbSpeed;
    private float hitRadius;

    public LightningOrbsAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float percentAbilityPowerDealtMin, float percentAbilityPowerDealtMax, float throwPower, float distance, float chainRange, int durationTicks, float orbSpeed, float hitRadius) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, percentAbilityPowerDealtMin, percentAbilityPowerDealtMax, throwPower, distance, chainRange);
        this.durationTicks = durationTicks;
        this.orbSpeed = orbSpeed;
        this.hitRadius = hitRadius;
    }

    public LightningOrbsAbility() {
    }

    public float getOrbSpeed() {
        return this.orbSpeed;
    }

    public int getDurationTicks(LivingEntity player) {
        return EffectDurationHelper.adjustEffectDurationFloor(player, this.getUnmodifiedDurationTicks());
    }

    public int getUnmodifiedDurationTicks() {
        return this.durationTicks;
    }

    public float getHitRadius() {
        return this.hitRadius;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            LightningOrbEntity orb = new LightningOrbEntity(player.f_19853_, (ServerPlayer)player, this);
            player.f_19853_.m_7967_((Entity)orb);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.durationTicks, buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.orbSpeed), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.hitRadius), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.durationTicks = Adapters.INT_SEGMENTED_7.readBits(buffer).orElse(40);
        this.orbSpeed = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(0.2f)).floatValue();
        this.hitRadius = Adapters.FLOAT.readBits(buffer).orElse(Float.valueOf(1.0f)).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(tag -> {
            Adapters.INT.writeNbt(this.durationTicks).ifPresent(t -> tag.m_128365_("durationTicks", t));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.orbSpeed)).ifPresent(t -> tag.m_128365_("orbSpeed", t));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.hitRadius)).ifPresent(t -> tag.m_128365_("hitRadius", t));
            return tag;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.durationTicks = Adapters.INT.readNbt(nbt.m_128423_("durationTicks")).orElse(40);
        this.orbSpeed = Adapters.FLOAT.readNbt(nbt.m_128423_("orbSpeed")).orElse(Float.valueOf(0.2f)).floatValue();
        this.hitRadius = Adapters.FLOAT.readNbt(nbt.m_128423_("hitRadius")).orElse(Float.valueOf(1.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.durationTicks).ifPresent(e -> json.add("durationTicks", e));
            Adapters.FLOAT.writeJson(Float.valueOf(this.orbSpeed)).ifPresent(e -> json.add("orbSpeed", e));
            Adapters.FLOAT.writeJson(Float.valueOf(this.hitRadius)).ifPresent(e -> json.add("hitRadius", e));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.durationTicks = Adapters.INT.readJson(json.get("durationTicks")).orElse(40);
        this.orbSpeed = Adapters.FLOAT.readJson(json.get("orbSpeed")).orElse(Float.valueOf(0.2f)).floatValue();
        this.hitRadius = Adapters.FLOAT.readJson(json.get("hitRadius")).orElse(Float.valueOf(1.0f)).floatValue();
    }
}

