/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.storage.IZonedWorld;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.ServerScheduler;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ManaBarrierAbility
extends InstantManaAbility {
    private int radius;
    private int durationTicks;

    public ManaBarrierAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int radius, int durationTicks) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.radius = radius;
        this.durationTicks = durationTicks;
    }

    public ManaBarrierAbility() {
    }

    public int getUnmodifiedRadius() {
        return this.radius;
    }

    public int getRadius(Entity entity) {
        int realRadius = this.radius;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            realRadius = Mth.m_14143_((float)AreaOfEffectHelper.adjustAreaOfEffect(livingEntity, this, realRadius));
        }
        return realRadius;
    }

    public int getDurationTicks() {
        return this.durationTicks;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            ServerLevel level = player.m_183503_();
            BlockPos center = player.m_142538_();
            BlockState state = ModBlocks.MANA_BARRIER.m_49966_();
            ArrayList placed = new ArrayList();
            int r = this.getRadius((Entity)player);
            for (int x = -r; x <= r; ++x) {
                for (int y = -r; y <= r; ++y) {
                    for (int z = -r; z <= r; ++z) {
                        BlockPos pos;
                        if (Math.abs(x) != r && Math.abs(y) != r && Math.abs(z) != r || !level.m_46859_(pos = center.m_142082_(x, y, z)) && !level.m_8055_(pos).m_60767_().m_76336_()) continue;
                        IZonedWorld.runWithBypass(level, true, () -> {
                            if (level.m_46597_(pos, state)) {
                                placed.add(pos.m_7949_());
                            }
                        });
                    }
                }
            }
            if (!placed.isEmpty()) {
                ServerScheduler.INSTANCE.schedule(this.durationTicks, () -> {
                    for (BlockPos pos : placed) {
                        if (!level.m_8055_(pos).m_60713_((Block)ModBlocks.MANA_BARRIER)) continue;
                        IZonedWorld.runWithBypass(level, true, () -> level.m_7471_(pos, false));
                    }
                });
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.MANA_SHIELD, SoundSource.PLAYERS, 0.2f, 1.0f);
            player.m_6330_(ModSounds.MANA_SHIELD, SoundSource.PLAYERS, 0.2f, 1.0f);
            return Ability.ActionResult.successCooldownDelayed(this.durationTicks);
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT.writeBits(this.radius, buffer);
        Adapters.INT.writeBits(this.durationTicks, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.radius = Adapters.INT.readBits(buffer).orElse(0);
        this.durationTicks = Adapters.INT.readBits(buffer).orElse(0);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.radius).ifPresent(tag -> nbt.m_128365_("radius", tag));
            Adapters.INT.writeNbt(this.durationTicks).ifPresent(tag -> nbt.m_128365_("durationTicks", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.radius = Adapters.INT.readNbt(nbt.m_128423_("radius")).orElse(0);
        this.durationTicks = Adapters.INT.readNbt(nbt.m_128423_("durationTicks")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.radius).ifPresent(e -> json.add("radius", e));
            Adapters.INT.writeJson(this.durationTicks).ifPresent(e -> json.add("durationTicks", e));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.radius = Adapters.INT.readJson(json.get("radius")).orElse(0);
        this.durationTicks = Adapters.INT.readJson(json.get("durationTicks")).orElse(0);
    }
}

