/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import iskallia.vault.VaultMod;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.etching.EtchingGearAttributes;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantAbility;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ManaShieldAbility
extends InstantManaAbility {
    private int durationTicks;
    private int healthPoints;

    public ManaShieldAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, int manaCost, int duration, int healthPoints) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.durationTicks = duration;
        this.healthPoints = healthPoints;
    }

    public ManaShieldAbility() {
    }

    public int getDurationTicks() {
        return this.durationTicks;
    }

    public int getHealthPoints() {
        return this.healthPoints;
    }

    protected MobEffect getEffect() {
        return ModEffects.MANA_SHIELD;
    }

    @Override
    protected boolean canDoAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> (!player.m_21023_(this.getEffect()) || player.m_21051_(ModAttributes.MANA_SHIELD).m_22135_() < (double)this.healthPoints) && super.canDoAction(context)).orElse(false);
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (player.m_21023_(this.getEffect())) {
                player.m_21195_(this.getEffect());
            }
            player.m_7292_(new MobEffectInstance(this.getEffect(), this.getDurationTicks(), 0, false, false, true));
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.MANA_SHIELD, SoundSource.PLAYERS, 0.2f, 0.2f);
            return Ability.ActionResult.successCooldownDeferred();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    public void onRemove(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(entity -> entity.m_21195_(this.getEffect()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void on(LivingDamageEvent event) {
        ServerPlayer player;
        block8: {
            block7: {
                Entity entity = event.getEntity();
                if (!(entity instanceof ServerPlayer)) break block7;
                player = (ServerPlayer)entity;
                if (!(event.getAmount() <= 0.0f)) break block8;
            }
            return;
        }
        AttributeInstance manaShieldAttribute = player.m_21051_(ModAttributes.MANA_SHIELD);
        AttributeModifier manaShieldAttributeModifier = manaShieldAttribute.m_22111_(ManaShieldEffect.MANA_SHIELD_MODIFIER_ID);
        if (manaShieldAttributeModifier == null) {
            return;
        }
        double manaShieldHealthPoints = manaShieldAttributeModifier.m_22218_();
        if (manaShieldHealthPoints <= 0.0) {
            return;
        }
        double manaShieldLost = Math.min(manaShieldHealthPoints, (double)event.getAmount());
        event.setAmount(event.getAmount() - (float)manaShieldLost);
        manaShieldAttribute.m_22120_(ManaShieldEffect.MANA_SHIELD_MODIFIER_ID);
        double remainingManaShieldHealthPoints = manaShieldHealthPoints - manaShieldLost;
        float pitch = 0.7f + player.m_183503_().m_5822_().nextFloat(0.6f);
        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.MANA_SHIELD_HIT, SoundSource.PLAYERS, 0.1f, pitch);
        if (remainingManaShieldHealthPoints <= 0.0) {
            player.m_21195_(ModEffects.MANA_SHIELD);
        } else {
            manaShieldAttribute.m_22118_(new AttributeModifier(ManaShieldEffect.MANA_SHIELD_MODIFIER_ID, "Mana Shield", remainingManaShieldHealthPoints, AttributeModifier.Operation.ADDITION));
        }
    }

    protected void onDamageAbsorbed(ServerPlayer player, float amount) {
    }

    protected void onEffectRemoved(ServerPlayer player) {
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT.writeBits(this.durationTicks, buffer);
        Adapters.INT.writeBits(this.healthPoints, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.durationTicks = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        this.healthPoints = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.durationTicks).ifPresent(tag -> nbt.m_128365_("durationTicks", tag));
            Adapters.INT.writeNbt(this.healthPoints).ifPresent(tag -> nbt.m_128365_("healthPoints", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.durationTicks = Adapters.INT.readNbt(nbt.m_128423_("durationTicks")).orElse(0);
        this.healthPoints = Adapters.INT.readNbt(nbt.m_128423_("healthPoints")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.durationTicks).ifPresent(element -> json.add("durationTicks", element));
            Adapters.INT.writeJson(this.healthPoints).ifPresent(element -> json.add("healthPoints", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.durationTicks = Adapters.INT.readJson(json.get("durationTicks")).orElse(0);
        this.healthPoints = Adapters.INT.readJson(json.get("healthPoints")).orElse(0);
    }

    public static class ManaShieldEffect
    extends MobEffect {
        private static final UUID MANA_SHIELD_MODIFIER_ID = UUID.fromString("f0761ea3-2f69-4da3-a1b4-2d7d5ea21f8d");

        public ManaShieldEffect(int color, ResourceLocation registryName) {
            super(MobEffectCategory.BENEFICIAL, color);
            this.setRegistryName(registryName);
        }

        public void m_6385_(LivingEntity pLivingEntity, AttributeMap pAttributeMap, int pAmplifier) {
            block0: {
                ServerPlayer player;
                AbilityTree abilities;
                List<ManaShieldAbility> manaShieldAbilities;
                Iterator<ManaShieldAbility> iterator;
                super.m_6385_(pLivingEntity, pAttributeMap, pAmplifier);
                if (!(pLivingEntity instanceof ServerPlayer) || !(iterator = (manaShieldAbilities = (abilities = PlayerAbilitiesData.get((player = (ServerPlayer)pLivingEntity).m_183503_()).getAbilities((Player)player)).getAll(ManaShieldAbility.class, Skill::isUnlocked)).iterator()).hasNext()) break block0;
                ManaShieldAbility manaShieldAbility = iterator.next();
                player.m_21051_(ModAttributes.MANA_SHIELD).m_22118_(new AttributeModifier(MANA_SHIELD_MODIFIER_ID, "Mana Shield", (double)manaShieldAbility.getHealthPoints(), AttributeModifier.Operation.ADDITION));
            }
        }

        public MobEffect m_19472_(Attribute pAttribute, String pUuid, double pAmount, AttributeModifier.Operation pOperation) {
            return super.m_19472_(pAttribute, pUuid, pAmount, pOperation);
        }

        public void m_6386_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
            super.m_6386_(livingEntity, attributeMap, amplifier);
            AttributeInstance attribute = livingEntity.m_21051_(ModAttributes.MANA_SHIELD);
            if (attribute == null) {
                return;
            }
            attribute.m_22120_(MANA_SHIELD_MODIFIER_ID);
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.MANA_SHIELD_NOVA).stream().findFirst().ifPresent(stack -> {
                    String abilityId = (String)((Pair)stack.getValue()).getFirst();
                    int level = (Integer)((Pair)stack.getValue()).getSecond();
                    ModConfigs.ABILITIES.getAbilityById(abilityId).filter(s -> s instanceof TieredSkill).map(s -> (TieredSkill)s).ifPresent(tiered -> {
                        int idx = Mth.m_14045_((int)level, (int)1, (int)tiered.getTiers().size());
                        LearnableSkill child = tiered.getChild(idx);
                        if (child instanceof InstantAbility) {
                            InstantAbility ability = (InstantAbility)child;
                            ability.onAction(SkillContext.of(player));
                        } else {
                            VaultMod.LOGGER.error("ManaShieldNovaEtching ability {} level {} is not InstantAbility", (Object)abilityId, (Object)idx);
                        }
                    });
                });
                PlayerAbilitiesData.setAbilityOnCooldown(player, ManaShieldAbility.class);
            }
        }
    }
}

