/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.ability.effect.MegaJumpAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.world.data.ServerVaults;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MegaJumpBreakDownAbility
extends MegaJumpAbility {
    private int radius;

    public MegaJumpBreakDownAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int height, int radius) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, height);
        this.radius = radius;
    }

    public MegaJumpBreakDownAbility() {
    }

    public int getRadius() {
        return this.radius;
    }

    @Override
    protected boolean canDoAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> super.canDoAction(context) && ServerVaults.get(player.f_19853_).isPresent()).orElse(false);
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            int height = this.getHeight((Player)player);
            if (height == 0) {
                this.breakBlocks(player.m_183503_(), height, (ServerPlayer)player);
                return Ability.ActionResult.successCooldownImmediate();
            }
            double magnitude = (double)height * 0.15;
            double addY = -Math.min(0.0, player.m_20184_().m_7098_());
            player.m_5997_(0.0, -(addY + magnitude), 0.0);
            player.m_36320_();
            player.f_19864_ = true;
            this.breakBlocks(player.m_183503_(), height, (ServerPlayer)player);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    private void breakBlocks(ServerLevel world, int height, ServerPlayer player) {
        if (player.f_8941_.m_9290_().m_46407_()) {
            return;
        }
        int radius = Math.max(this.getRadius(), 1);
        int depth = Math.max(height, 1) + 1;
        BlockPos centerPos = player.m_142538_();
        if (depth > 2) {
            centerPos = centerPos.m_6625_(depth - 2);
        }
        BlockHelper.withEllipsoidPositions(centerPos, radius, depth, radius, offset -> {
            float hardness;
            BlockState state = world.m_8055_(offset);
            if (this.canBreakBlock(state) && (hardness = state.m_60800_((BlockGetter)world, offset)) >= 0.0f && hardness <= 25.0f) {
                this.destroyBlock(world, (BlockPos)offset, (Player)player);
            }
        });
    }

    private void destroyBlock(ServerLevel world, BlockPos pos, Player player) {
        ItemStack miningItem = new ItemStack((ItemLike)Items.f_42390_);
        Block.m_49881_((BlockState)world.m_8055_(pos), (Level)world, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), null, (ItemStack)miningItem);
        world.m_46953_(pos, false, (Entity)player);
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.radius, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.radius = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.radius).ifPresent(tag -> nbt.m_128365_("radius", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.radius = Adapters.INT.readNbt(nbt.m_128423_("radius")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.radius).ifPresent(element -> json.add("radius", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.radius = Adapters.INT.readJson(json.get("radius")).orElse(0);
    }
}

