/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.ability.effect.MegaJumpAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.ServerVaults;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MegaJumpBreakUpAbility
extends MegaJumpAbility {
    private int ticks;

    public MegaJumpBreakUpAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int height) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, height);
        this.ticks = 0;
    }

    public MegaJumpBreakUpAbility() {
    }

    @Override
    protected boolean canDoAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> super.canDoAction(context) && ServerVaults.get(player.f_19853_).isPresent()).orElse(false);
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            super.doAction(context);
            this.ticks = 30;
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.player.m_20193_().m_5776_() || !(event.player.m_20193_() instanceof ServerLevel)) {
            return;
        }
        Player player = event.player;
        ServerLevel world = (ServerLevel)player.m_20193_();
        AbilityTree abilities = PlayerAbilitiesData.get(world).getAbilities(player);
        Ability focusedAbilityNode = abilities.getSelectedAbility().orElse(null);
        for (MegaJumpBreakUpAbility ability : abilities.getAll(MegaJumpBreakUpAbility.class, Skill::isUnlocked)) {
            if (ability.ticks <= 0) continue;
            int ticks = ability.ticks;
            if (--ticks <= 0) {
                ability.ticks = 0;
                continue;
            }
            ability.ticks = ticks;
            if (focusedAbilityNode == null || focusedAbilityNode.getClass() != ability.getClass()) continue;
            float radius = AreaOfEffectHelper.adjustAreaOfEffect((LivingEntity)player, focusedAbilityNode, 4.0f);
            float yRadius = AreaOfEffectHelper.adjustAreaOfEffect((LivingEntity)player, focusedAbilityNode, 6.0f);
            BlockHelper.withEllipsoidPositions(player.m_142538_().m_6630_(3), radius, yRadius, radius, offset -> {
                float hardness;
                BlockState state = world.m_8055_(offset);
                if (ability.canBreakBlock(state) && (hardness = state.m_60800_((BlockGetter)world, offset)) >= 0.0f && hardness <= 25.0f) {
                    ability.destroyBlock(world, (BlockPos)offset, player);
                }
            });
        }
    }

    private void destroyBlock(ServerLevel world, BlockPos pos, Player player) {
        ItemStack miningItem = new ItemStack((ItemLike)Items.f_42390_);
        Block.m_49881_((BlockState)world.m_8055_(pos), (Level)world, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), null, (ItemStack)miningItem);
        world.m_46953_(pos, false, (Entity)player);
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.ticks, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.ticks = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.ticks).ifPresent(tag -> nbt.m_128365_("ticks", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.ticks = Adapters.INT.readNbt(nbt.m_128423_("ticks")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.ticks).ifPresent(element -> json.add("ticks", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.ticks = Adapters.INT.readJson(json.get("ticks")).orElse(0);
    }
}

